package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.EnvironmentArn
import scala.jdk.CollectionConverters.*
final case class CreateEnvironmentResponse(arn: Option[EnvironmentArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.CreateEnvironmentResponse = {
    import CreateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.CreateEnvironmentResponse
      .builder()
      .optionallyWith(
        arn.map(value => EnvironmentArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.CreateEnvironmentResponse.ReadOnly =
    zio.aws.mwaa.model.CreateEnvironmentResponse.wrap(buildAwsValue())
}
object CreateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.CreateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.CreateEnvironmentResponse =
      zio.aws.mwaa.model.CreateEnvironmentResponse(arn.map(value => value))
    def arn: Option[EnvironmentArn]
    def getArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.CreateEnvironmentResponse
  ) extends zio.aws.mwaa.model.CreateEnvironmentResponse.ReadOnly {
    override val arn: Option[EnvironmentArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mwaa.model.primitives.EnvironmentArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.CreateEnvironmentResponse
  ): zio.aws.mwaa.model.CreateEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
