package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mwaa.model.primitives.EnvironmentName
import scala.jdk.CollectionConverters.*
final case class CreateWebLoginTokenRequest(name: EnvironmentName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenRequest = {
    import CreateWebLoginTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenRequest
      .builder()
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.CreateWebLoginTokenRequest.ReadOnly =
    zio.aws.mwaa.model.CreateWebLoginTokenRequest.wrap(buildAwsValue())
}
object CreateWebLoginTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.CreateWebLoginTokenRequest =
      zio.aws.mwaa.model.CreateWebLoginTokenRequest(name)
    def name: EnvironmentName
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenRequest
  ) extends zio.aws.mwaa.model.CreateWebLoginTokenRequest.ReadOnly {
    override val name: EnvironmentName =
      zio.aws.mwaa.model.primitives.EnvironmentName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenRequest
  ): zio.aws.mwaa.model.CreateWebLoginTokenRequest.ReadOnly = new Wrapper(impl)
}
