package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.{
  SyntheticCreateWebLoginTokenResponseToken,
  Hostname
}
import scala.jdk.CollectionConverters.*
final case class CreateWebLoginTokenResponse(
    webServerHostname: Option[Hostname] = None,
    webToken: Option[SyntheticCreateWebLoginTokenResponseToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenResponse = {
    import CreateWebLoginTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenResponse
      .builder()
      .optionallyWith(
        webServerHostname.map(value => Hostname.unwrap(value): java.lang.String)
      )(_.webServerHostname)
      .optionallyWith(
        webToken.map(value =>
          SyntheticCreateWebLoginTokenResponseToken.unwrap(
            value
          ): java.lang.String
        )
      )(_.webToken)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.CreateWebLoginTokenResponse.ReadOnly =
    zio.aws.mwaa.model.CreateWebLoginTokenResponse.wrap(buildAwsValue())
}
object CreateWebLoginTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.CreateWebLoginTokenResponse =
      zio.aws.mwaa.model.CreateWebLoginTokenResponse(
        webServerHostname.map(value => value),
        webToken.map(value => value)
      )
    def webServerHostname: Option[Hostname]
    def webToken: Option[SyntheticCreateWebLoginTokenResponseToken]
    def getWebServerHostname: ZIO[Any, AwsError, Hostname] =
      AwsError.unwrapOptionField("webServerHostname", webServerHostname)
    def getWebToken
        : ZIO[Any, AwsError, SyntheticCreateWebLoginTokenResponseToken] =
      AwsError.unwrapOptionField("webToken", webToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenResponse
  ) extends zio.aws.mwaa.model.CreateWebLoginTokenResponse.ReadOnly {
    override val webServerHostname: Option[Hostname] = scala
      .Option(impl.webServerHostname())
      .map(value => zio.aws.mwaa.model.primitives.Hostname(value))
    override val webToken: Option[SyntheticCreateWebLoginTokenResponseToken] =
      scala
        .Option(impl.webToken())
        .map(value =>
          zio.aws.mwaa.model.primitives
            .SyntheticCreateWebLoginTokenResponseToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.CreateWebLoginTokenResponse
  ): zio.aws.mwaa.model.CreateWebLoginTokenResponse.ReadOnly = new Wrapper(impl)
}
