package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mwaa.model.primitives.EnvironmentName
import scala.jdk.CollectionConverters.*
final case class DeleteEnvironmentRequest(name: EnvironmentName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.DeleteEnvironmentRequest = {
    import DeleteEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.DeleteEnvironmentRequest
      .builder()
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.DeleteEnvironmentRequest.ReadOnly =
    zio.aws.mwaa.model.DeleteEnvironmentRequest.wrap(buildAwsValue())
}
object DeleteEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.DeleteEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.DeleteEnvironmentRequest =
      zio.aws.mwaa.model.DeleteEnvironmentRequest(name)
    def name: EnvironmentName
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.DeleteEnvironmentRequest
  ) extends zio.aws.mwaa.model.DeleteEnvironmentRequest.ReadOnly {
    override val name: EnvironmentName =
      zio.aws.mwaa.model.primitives.EnvironmentName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.DeleteEnvironmentRequest
  ): zio.aws.mwaa.model.DeleteEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
