package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Dimension(name: String, value: String) {
  def buildAwsValue(): software.amazon.awssdk.services.mwaa.model.Dimension = {
    import Dimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.Dimension
      .builder()
      .name(name: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.Dimension.ReadOnly =
    zio.aws.mwaa.model.Dimension.wrap(buildAwsValue())
}
object Dimension {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mwaa.model.Dimension] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.Dimension =
      zio.aws.mwaa.model.Dimension(name, value)
    def name: String
    def value: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.Dimension
  ) extends zio.aws.mwaa.model.Dimension.ReadOnly {
    override val name: String = impl.name(): String
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.Dimension
  ): zio.aws.mwaa.model.Dimension.ReadOnly = new Wrapper(impl)
}
