package zio.aws.mwaa.model
import java.time.Instant
import zio.aws.mwaa.model.primitives.{
  MinWorkers,
  IamRoleArn,
  WebserverUrl,
  S3BucketArn,
  ConfigValue,
  EnvironmentClass,
  CreatedAt,
  EnvironmentArn,
  Schedulers,
  WeeklyMaintenanceWindowStart,
  TagValue,
  EnvironmentName,
  KmsKey,
  S3ObjectVersion,
  AirflowVersion,
  MaxWorkers,
  ConfigKey,
  RelativePath,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Environment(
    airflowConfigurationOptions: Option[Map[ConfigKey, ConfigValue]] = None,
    airflowVersion: Option[AirflowVersion] = None,
    arn: Option[EnvironmentArn] = None,
    createdAt: Option[CreatedAt] = None,
    dagS3Path: Option[RelativePath] = None,
    environmentClass: Option[EnvironmentClass] = None,
    executionRoleArn: Option[IamRoleArn] = None,
    kmsKey: Option[KmsKey] = None,
    lastUpdate: Option[zio.aws.mwaa.model.LastUpdate] = None,
    loggingConfiguration: Option[zio.aws.mwaa.model.LoggingConfiguration] =
      None,
    maxWorkers: Option[MaxWorkers] = None,
    minWorkers: Option[MinWorkers] = None,
    name: Option[EnvironmentName] = None,
    networkConfiguration: Option[zio.aws.mwaa.model.NetworkConfiguration] =
      None,
    pluginsS3ObjectVersion: Option[S3ObjectVersion] = None,
    pluginsS3Path: Option[RelativePath] = None,
    requirementsS3ObjectVersion: Option[S3ObjectVersion] = None,
    requirementsS3Path: Option[RelativePath] = None,
    schedulers: Option[Schedulers] = None,
    serviceRoleArn: Option[IamRoleArn] = None,
    sourceBucketArn: Option[S3BucketArn] = None,
    status: Option[zio.aws.mwaa.model.EnvironmentStatus] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    webserverAccessMode: Option[zio.aws.mwaa.model.WebserverAccessMode] = None,
    webserverUrl: Option[WebserverUrl] = None,
    weeklyMaintenanceWindowStart: Option[WeeklyMaintenanceWindowStart] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.Environment = {
    import Environment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.Environment
      .builder()
      .optionallyWith(
        airflowConfigurationOptions.map(value =>
          value
            .map({ case (key, value) =>
              (ConfigKey.unwrap(key): java.lang.String) -> (ConfigValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.airflowConfigurationOptions)
      .optionallyWith(
        airflowVersion.map(value =>
          AirflowVersion.unwrap(value): java.lang.String
        )
      )(_.airflowVersion)
      .optionallyWith(
        arn.map(value => EnvironmentArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        dagS3Path.map(value => RelativePath.unwrap(value): java.lang.String)
      )(_.dagS3Path)
      .optionallyWith(
        environmentClass.map(value =>
          EnvironmentClass.unwrap(value): java.lang.String
        )
      )(_.environmentClass)
      .optionallyWith(
        executionRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.executionRoleArn)
      .optionallyWith(
        kmsKey.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(lastUpdate.map(value => value.buildAwsValue()))(
        _.lastUpdate
      )
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(
        maxWorkers.map(value => MaxWorkers.unwrap(value): Integer)
      )(_.maxWorkers)
      .optionallyWith(
        minWorkers.map(value => MinWorkers.unwrap(value): Integer)
      )(_.minWorkers)
      .optionallyWith(
        name.map(value => EnvironmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        pluginsS3ObjectVersion.map(value =>
          S3ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.pluginsS3ObjectVersion)
      .optionallyWith(
        pluginsS3Path.map(value => RelativePath.unwrap(value): java.lang.String)
      )(_.pluginsS3Path)
      .optionallyWith(
        requirementsS3ObjectVersion.map(value =>
          S3ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.requirementsS3ObjectVersion)
      .optionallyWith(
        requirementsS3Path.map(value =>
          RelativePath.unwrap(value): java.lang.String
        )
      )(_.requirementsS3Path)
      .optionallyWith(
        schedulers.map(value => Schedulers.unwrap(value): Integer)
      )(_.schedulers)
      .optionallyWith(
        serviceRoleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .optionallyWith(
        sourceBucketArn.map(value =>
          S3BucketArn.unwrap(value): java.lang.String
        )
      )(_.sourceBucketArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(webserverAccessMode.map(value => value.unwrap))(
        _.webserverAccessMode
      )
      .optionallyWith(
        webserverUrl.map(value => WebserverUrl.unwrap(value): java.lang.String)
      )(_.webserverUrl)
      .optionallyWith(
        weeklyMaintenanceWindowStart.map(value =>
          WeeklyMaintenanceWindowStart.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceWindowStart)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.Environment.ReadOnly =
    zio.aws.mwaa.model.Environment.wrap(buildAwsValue())
}
object Environment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mwaa.model.Environment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.Environment =
      zio.aws.mwaa.model.Environment(
        airflowConfigurationOptions.map(value => value),
        airflowVersion.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        dagS3Path.map(value => value),
        environmentClass.map(value => value),
        executionRoleArn.map(value => value),
        kmsKey.map(value => value),
        lastUpdate.map(value => value.asEditable),
        loggingConfiguration.map(value => value.asEditable),
        maxWorkers.map(value => value),
        minWorkers.map(value => value),
        name.map(value => value),
        networkConfiguration.map(value => value.asEditable),
        pluginsS3ObjectVersion.map(value => value),
        pluginsS3Path.map(value => value),
        requirementsS3ObjectVersion.map(value => value),
        requirementsS3Path.map(value => value),
        schedulers.map(value => value),
        serviceRoleArn.map(value => value),
        sourceBucketArn.map(value => value),
        status.map(value => value),
        tags.map(value => value),
        webserverAccessMode.map(value => value),
        webserverUrl.map(value => value),
        weeklyMaintenanceWindowStart.map(value => value)
      )
    def airflowConfigurationOptions: Option[Map[ConfigKey, ConfigValue]]
    def airflowVersion: Option[AirflowVersion]
    def arn: Option[EnvironmentArn]
    def createdAt: Option[CreatedAt]
    def dagS3Path: Option[RelativePath]
    def environmentClass: Option[EnvironmentClass]
    def executionRoleArn: Option[IamRoleArn]
    def kmsKey: Option[KmsKey]
    def lastUpdate: Option[zio.aws.mwaa.model.LastUpdate.ReadOnly]
    def loggingConfiguration
        : Option[zio.aws.mwaa.model.LoggingConfiguration.ReadOnly]
    def maxWorkers: Option[MaxWorkers]
    def minWorkers: Option[MinWorkers]
    def name: Option[EnvironmentName]
    def networkConfiguration
        : Option[zio.aws.mwaa.model.NetworkConfiguration.ReadOnly]
    def pluginsS3ObjectVersion: Option[S3ObjectVersion]
    def pluginsS3Path: Option[RelativePath]
    def requirementsS3ObjectVersion: Option[S3ObjectVersion]
    def requirementsS3Path: Option[RelativePath]
    def schedulers: Option[Schedulers]
    def serviceRoleArn: Option[IamRoleArn]
    def sourceBucketArn: Option[S3BucketArn]
    def status: Option[zio.aws.mwaa.model.EnvironmentStatus]
    def tags: Option[Map[TagKey, TagValue]]
    def webserverAccessMode: Option[zio.aws.mwaa.model.WebserverAccessMode]
    def webserverUrl: Option[WebserverUrl]
    def weeklyMaintenanceWindowStart: Option[WeeklyMaintenanceWindowStart]
    def getAirflowConfigurationOptions
        : ZIO[Any, AwsError, Map[ConfigKey, ConfigValue]] =
      AwsError.unwrapOptionField(
        "airflowConfigurationOptions",
        airflowConfigurationOptions
      )
    def getAirflowVersion: ZIO[Any, AwsError, AirflowVersion] =
      AwsError.unwrapOptionField("airflowVersion", airflowVersion)
    def getArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDagS3Path: ZIO[Any, AwsError, RelativePath] =
      AwsError.unwrapOptionField("dagS3Path", dagS3Path)
    def getEnvironmentClass: ZIO[Any, AwsError, EnvironmentClass] =
      AwsError.unwrapOptionField("environmentClass", environmentClass)
    def getExecutionRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getKmsKey: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getLastUpdate
        : ZIO[Any, AwsError, zio.aws.mwaa.model.LastUpdate.ReadOnly] =
      AwsError.unwrapOptionField("lastUpdate", lastUpdate)
    def getLoggingConfiguration
        : ZIO[Any, AwsError, zio.aws.mwaa.model.LoggingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getMaxWorkers: ZIO[Any, AwsError, MaxWorkers] =
      AwsError.unwrapOptionField("maxWorkers", maxWorkers)
    def getMinWorkers: ZIO[Any, AwsError, MinWorkers] =
      AwsError.unwrapOptionField("minWorkers", minWorkers)
    def getName: ZIO[Any, AwsError, EnvironmentName] =
      AwsError.unwrapOptionField("name", name)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.mwaa.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getPluginsS3ObjectVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField(
        "pluginsS3ObjectVersion",
        pluginsS3ObjectVersion
      )
    def getPluginsS3Path: ZIO[Any, AwsError, RelativePath] =
      AwsError.unwrapOptionField("pluginsS3Path", pluginsS3Path)
    def getRequirementsS3ObjectVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField(
        "requirementsS3ObjectVersion",
        requirementsS3ObjectVersion
      )
    def getRequirementsS3Path: ZIO[Any, AwsError, RelativePath] =
      AwsError.unwrapOptionField("requirementsS3Path", requirementsS3Path)
    def getSchedulers: ZIO[Any, AwsError, Schedulers] =
      AwsError.unwrapOptionField("schedulers", schedulers)
    def getServiceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getSourceBucketArn: ZIO[Any, AwsError, S3BucketArn] =
      AwsError.unwrapOptionField("sourceBucketArn", sourceBucketArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.mwaa.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWebserverAccessMode
        : ZIO[Any, AwsError, zio.aws.mwaa.model.WebserverAccessMode] =
      AwsError.unwrapOptionField("webserverAccessMode", webserverAccessMode)
    def getWebserverUrl: ZIO[Any, AwsError, WebserverUrl] =
      AwsError.unwrapOptionField("webserverUrl", webserverUrl)
    def getWeeklyMaintenanceWindowStart
        : ZIO[Any, AwsError, WeeklyMaintenanceWindowStart] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceWindowStart",
        weeklyMaintenanceWindowStart
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.Environment
  ) extends zio.aws.mwaa.model.Environment.ReadOnly {
    override val airflowConfigurationOptions
        : Option[Map[ConfigKey, ConfigValue]] = scala
      .Option(impl.airflowConfigurationOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mwaa.model.primitives.ConfigKey(
              key
            ) -> zio.aws.mwaa.model.primitives.ConfigValue(value)
          })
          .toMap
      )
    override val airflowVersion: Option[AirflowVersion] = scala
      .Option(impl.airflowVersion())
      .map(value => zio.aws.mwaa.model.primitives.AirflowVersion(value))
    override val arn: Option[EnvironmentArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mwaa.model.primitives.EnvironmentArn(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.mwaa.model.primitives.CreatedAt(value))
    override val dagS3Path: Option[RelativePath] = scala
      .Option(impl.dagS3Path())
      .map(value => zio.aws.mwaa.model.primitives.RelativePath(value))
    override val environmentClass: Option[EnvironmentClass] = scala
      .Option(impl.environmentClass())
      .map(value => zio.aws.mwaa.model.primitives.EnvironmentClass(value))
    override val executionRoleArn: Option[IamRoleArn] = scala
      .Option(impl.executionRoleArn())
      .map(value => zio.aws.mwaa.model.primitives.IamRoleArn(value))
    override val kmsKey: Option[KmsKey] = scala
      .Option(impl.kmsKey())
      .map(value => zio.aws.mwaa.model.primitives.KmsKey(value))
    override val lastUpdate: Option[zio.aws.mwaa.model.LastUpdate.ReadOnly] =
      scala
        .Option(impl.lastUpdate())
        .map(value => zio.aws.mwaa.model.LastUpdate.wrap(value))
    override val loggingConfiguration
        : Option[zio.aws.mwaa.model.LoggingConfiguration.ReadOnly] = scala
      .Option(impl.loggingConfiguration())
      .map(value => zio.aws.mwaa.model.LoggingConfiguration.wrap(value))
    override val maxWorkers: Option[MaxWorkers] = scala
      .Option(impl.maxWorkers())
      .map(value => zio.aws.mwaa.model.primitives.MaxWorkers(value))
    override val minWorkers: Option[MinWorkers] = scala
      .Option(impl.minWorkers())
      .map(value => zio.aws.mwaa.model.primitives.MinWorkers(value))
    override val name: Option[EnvironmentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.mwaa.model.primitives.EnvironmentName(value))
    override val networkConfiguration
        : Option[zio.aws.mwaa.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.mwaa.model.NetworkConfiguration.wrap(value))
    override val pluginsS3ObjectVersion: Option[S3ObjectVersion] = scala
      .Option(impl.pluginsS3ObjectVersion())
      .map(value => zio.aws.mwaa.model.primitives.S3ObjectVersion(value))
    override val pluginsS3Path: Option[RelativePath] = scala
      .Option(impl.pluginsS3Path())
      .map(value => zio.aws.mwaa.model.primitives.RelativePath(value))
    override val requirementsS3ObjectVersion: Option[S3ObjectVersion] = scala
      .Option(impl.requirementsS3ObjectVersion())
      .map(value => zio.aws.mwaa.model.primitives.S3ObjectVersion(value))
    override val requirementsS3Path: Option[RelativePath] = scala
      .Option(impl.requirementsS3Path())
      .map(value => zio.aws.mwaa.model.primitives.RelativePath(value))
    override val schedulers: Option[Schedulers] = scala
      .Option(impl.schedulers())
      .map(value => zio.aws.mwaa.model.primitives.Schedulers(value))
    override val serviceRoleArn: Option[IamRoleArn] = scala
      .Option(impl.serviceRoleArn())
      .map(value => zio.aws.mwaa.model.primitives.IamRoleArn(value))
    override val sourceBucketArn: Option[S3BucketArn] = scala
      .Option(impl.sourceBucketArn())
      .map(value => zio.aws.mwaa.model.primitives.S3BucketArn(value))
    override val status: Option[zio.aws.mwaa.model.EnvironmentStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.mwaa.model.EnvironmentStatus.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mwaa.model.primitives
              .TagKey(key) -> zio.aws.mwaa.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val webserverAccessMode
        : Option[zio.aws.mwaa.model.WebserverAccessMode] = scala
      .Option(impl.webserverAccessMode())
      .map(value => zio.aws.mwaa.model.WebserverAccessMode.wrap(value))
    override val webserverUrl: Option[WebserverUrl] = scala
      .Option(impl.webserverUrl())
      .map(value => zio.aws.mwaa.model.primitives.WebserverUrl(value))
    override val weeklyMaintenanceWindowStart
        : Option[WeeklyMaintenanceWindowStart] = scala
      .Option(impl.weeklyMaintenanceWindowStart())
      .map(value =>
        zio.aws.mwaa.model.primitives.WeeklyMaintenanceWindowStart(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.Environment
  ): zio.aws.mwaa.model.Environment.ReadOnly = new Wrapper(impl)
}
