package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetEnvironmentResponse(
    environment: Option[zio.aws.mwaa.model.Environment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.GetEnvironmentResponse = {
    import GetEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.GetEnvironmentResponse
      .builder()
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.GetEnvironmentResponse.ReadOnly =
    zio.aws.mwaa.model.GetEnvironmentResponse.wrap(buildAwsValue())
}
object GetEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.GetEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.GetEnvironmentResponse =
      zio.aws.mwaa.model
        .GetEnvironmentResponse(environment.map(value => value.asEditable))
    def environment: Option[zio.aws.mwaa.model.Environment.ReadOnly]
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.mwaa.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.GetEnvironmentResponse
  ) extends zio.aws.mwaa.model.GetEnvironmentResponse.ReadOnly {
    override val environment: Option[zio.aws.mwaa.model.Environment.ReadOnly] =
      scala
        .Option(impl.environment())
        .map(value => zio.aws.mwaa.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.GetEnvironmentResponse
  ): zio.aws.mwaa.model.GetEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
