package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.UpdateCreatedAt
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class LastUpdate(
    createdAt: Option[UpdateCreatedAt] = None,
    error: Option[zio.aws.mwaa.model.UpdateError] = None,
    status: Option[zio.aws.mwaa.model.UpdateStatus] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.mwaa.model.LastUpdate = {
    import LastUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.LastUpdate
      .builder()
      .optionallyWith(
        createdAt.map(value => UpdateCreatedAt.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.LastUpdate.ReadOnly =
    zio.aws.mwaa.model.LastUpdate.wrap(buildAwsValue())
}
object LastUpdate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mwaa.model.LastUpdate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.LastUpdate =
      zio.aws.mwaa.model.LastUpdate(
        createdAt.map(value => value),
        error.map(value => value.asEditable),
        status.map(value => value)
      )
    def createdAt: Option[UpdateCreatedAt]
    def error: Option[zio.aws.mwaa.model.UpdateError.ReadOnly]
    def status: Option[zio.aws.mwaa.model.UpdateStatus]
    def getCreatedAt: ZIO[Any, AwsError, UpdateCreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getError: ZIO[Any, AwsError, zio.aws.mwaa.model.UpdateError.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
    def getStatus: ZIO[Any, AwsError, zio.aws.mwaa.model.UpdateStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.LastUpdate
  ) extends zio.aws.mwaa.model.LastUpdate.ReadOnly {
    override val createdAt: Option[UpdateCreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.mwaa.model.primitives.UpdateCreatedAt(value))
    override val error: Option[zio.aws.mwaa.model.UpdateError.ReadOnly] = scala
      .Option(impl.error())
      .map(value => zio.aws.mwaa.model.UpdateError.wrap(value))
    override val status: Option[zio.aws.mwaa.model.UpdateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.mwaa.model.UpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.LastUpdate
  ): zio.aws.mwaa.model.LastUpdate.ReadOnly = new Wrapper(impl)
}
