package zio.aws.mwaa.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.{
  NextToken,
  ListEnvironmentsInputMaxResultsInteger
}
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentsRequest(
    maxResults: Option[ListEnvironmentsInputMaxResultsInteger] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.ListEnvironmentsRequest = {
    import ListEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.ListEnvironmentsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListEnvironmentsInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.ListEnvironmentsRequest.ReadOnly =
    zio.aws.mwaa.model.ListEnvironmentsRequest.wrap(buildAwsValue())
}
object ListEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.ListEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.ListEnvironmentsRequest =
      zio.aws.mwaa.model.ListEnvironmentsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[ListEnvironmentsInputMaxResultsInteger]
    def nextToken: Option[NextToken]
    def getMaxResults
        : ZIO[Any, AwsError, ListEnvironmentsInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.ListEnvironmentsRequest
  ) extends zio.aws.mwaa.model.ListEnvironmentsRequest.ReadOnly {
    override val maxResults: Option[ListEnvironmentsInputMaxResultsInteger] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.mwaa.model.primitives
            .ListEnvironmentsInputMaxResultsInteger(value)
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mwaa.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.ListEnvironmentsRequest
  ): zio.aws.mwaa.model.ListEnvironmentsRequest.ReadOnly = new Wrapper(impl)
}
