package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.{NextToken, EnvironmentName}
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentsResponse(
    environments: Iterable[EnvironmentName],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.ListEnvironmentsResponse = {
    import ListEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.ListEnvironmentsResponse
      .builder()
      .environments(environments.map { item =>
        EnvironmentName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.ListEnvironmentsResponse.ReadOnly =
    zio.aws.mwaa.model.ListEnvironmentsResponse.wrap(buildAwsValue())
}
object ListEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.ListEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.ListEnvironmentsResponse =
      zio.aws.mwaa.model
        .ListEnvironmentsResponse(environments, nextToken.map(value => value))
    def environments: List[EnvironmentName]
    def nextToken: Option[NextToken]
    def getEnvironments: ZIO[Any, Nothing, List[EnvironmentName]] =
      ZIO.succeed(environments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.ListEnvironmentsResponse
  ) extends zio.aws.mwaa.model.ListEnvironmentsResponse.ReadOnly {
    override val environments: List[EnvironmentName] = impl
      .environments()
      .asScala
      .map { item =>
        zio.aws.mwaa.model.primitives.EnvironmentName(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mwaa.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.ListEnvironmentsResponse
  ): zio.aws.mwaa.model.ListEnvironmentsResponse.ReadOnly = new Wrapper(impl)
}
