package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mwaa.model.primitives.EnvironmentArn
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: EnvironmentArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(EnvironmentArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.mwaa.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.ListTagsForResourceRequest =
      zio.aws.mwaa.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: EnvironmentArn
    def getResourceArn: ZIO[Any, Nothing, EnvironmentArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.ListTagsForResourceRequest
  ) extends zio.aws.mwaa.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: EnvironmentArn =
      zio.aws.mwaa.model.primitives.EnvironmentArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.ListTagsForResourceRequest
  ): zio.aws.mwaa.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
