package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoggingConfiguration(
    dagProcessingLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfiguration] =
      None,
    schedulerLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfiguration] = None,
    taskLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfiguration] = None,
    webserverLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfiguration] = None,
    workerLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.LoggingConfiguration = {
    import LoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.LoggingConfiguration
      .builder()
      .optionallyWith(dagProcessingLogs.map(value => value.buildAwsValue()))(
        _.dagProcessingLogs
      )
      .optionallyWith(schedulerLogs.map(value => value.buildAwsValue()))(
        _.schedulerLogs
      )
      .optionallyWith(taskLogs.map(value => value.buildAwsValue()))(_.taskLogs)
      .optionallyWith(webserverLogs.map(value => value.buildAwsValue()))(
        _.webserverLogs
      )
      .optionallyWith(workerLogs.map(value => value.buildAwsValue()))(
        _.workerLogs
      )
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.LoggingConfiguration.ReadOnly =
    zio.aws.mwaa.model.LoggingConfiguration.wrap(buildAwsValue())
}
object LoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.LoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.LoggingConfiguration =
      zio.aws.mwaa.model.LoggingConfiguration(
        dagProcessingLogs.map(value => value.asEditable),
        schedulerLogs.map(value => value.asEditable),
        taskLogs.map(value => value.asEditable),
        webserverLogs.map(value => value.asEditable),
        workerLogs.map(value => value.asEditable)
      )
    def dagProcessingLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly]
    def schedulerLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly]
    def taskLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly]
    def webserverLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly]
    def workerLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly]
    def getDagProcessingLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("dagProcessingLogs", dagProcessingLogs)
    def getSchedulerLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("schedulerLogs", schedulerLogs)
    def getTaskLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("taskLogs", taskLogs)
    def getWebserverLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("webserverLogs", webserverLogs)
    def getWorkerLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("workerLogs", workerLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.LoggingConfiguration
  ) extends zio.aws.mwaa.model.LoggingConfiguration.ReadOnly {
    override val dagProcessingLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly] = scala
      .Option(impl.dagProcessingLogs())
      .map(value => zio.aws.mwaa.model.ModuleLoggingConfiguration.wrap(value))
    override val schedulerLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly] = scala
      .Option(impl.schedulerLogs())
      .map(value => zio.aws.mwaa.model.ModuleLoggingConfiguration.wrap(value))
    override val taskLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly] = scala
      .Option(impl.taskLogs())
      .map(value => zio.aws.mwaa.model.ModuleLoggingConfiguration.wrap(value))
    override val webserverLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly] = scala
      .Option(impl.webserverLogs())
      .map(value => zio.aws.mwaa.model.ModuleLoggingConfiguration.wrap(value))
    override val workerLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly] = scala
      .Option(impl.workerLogs())
      .map(value => zio.aws.mwaa.model.ModuleLoggingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.LoggingConfiguration
  ): zio.aws.mwaa.model.LoggingConfiguration.ReadOnly = new Wrapper(impl)
}
