package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoggingConfigurationInput(
    dagProcessingLogs: Option[
      zio.aws.mwaa.model.ModuleLoggingConfigurationInput
    ] = None,
    schedulerLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput] =
      None,
    taskLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput] = None,
    webserverLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput] =
      None,
    workerLogs: Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.LoggingConfigurationInput = {
    import LoggingConfigurationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.LoggingConfigurationInput
      .builder()
      .optionallyWith(dagProcessingLogs.map(value => value.buildAwsValue()))(
        _.dagProcessingLogs
      )
      .optionallyWith(schedulerLogs.map(value => value.buildAwsValue()))(
        _.schedulerLogs
      )
      .optionallyWith(taskLogs.map(value => value.buildAwsValue()))(_.taskLogs)
      .optionallyWith(webserverLogs.map(value => value.buildAwsValue()))(
        _.webserverLogs
      )
      .optionallyWith(workerLogs.map(value => value.buildAwsValue()))(
        _.workerLogs
      )
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.LoggingConfigurationInput.ReadOnly =
    zio.aws.mwaa.model.LoggingConfigurationInput.wrap(buildAwsValue())
}
object LoggingConfigurationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.LoggingConfigurationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.LoggingConfigurationInput =
      zio.aws.mwaa.model.LoggingConfigurationInput(
        dagProcessingLogs.map(value => value.asEditable),
        schedulerLogs.map(value => value.asEditable),
        taskLogs.map(value => value.asEditable),
        webserverLogs.map(value => value.asEditable),
        workerLogs.map(value => value.asEditable)
      )
    def dagProcessingLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly]
    def schedulerLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly]
    def taskLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly]
    def webserverLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly]
    def workerLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly]
    def getDagProcessingLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("dagProcessingLogs", dagProcessingLogs)
    def getSchedulerLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("schedulerLogs", schedulerLogs)
    def getTaskLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("taskLogs", taskLogs)
    def getWebserverLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("webserverLogs", webserverLogs)
    def getWorkerLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("workerLogs", workerLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.LoggingConfigurationInput
  ) extends zio.aws.mwaa.model.LoggingConfigurationInput.ReadOnly {
    override val dagProcessingLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly] =
      scala
        .Option(impl.dagProcessingLogs())
        .map(value =>
          zio.aws.mwaa.model.ModuleLoggingConfigurationInput.wrap(value)
        )
    override val schedulerLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly] =
      scala
        .Option(impl.schedulerLogs())
        .map(value =>
          zio.aws.mwaa.model.ModuleLoggingConfigurationInput.wrap(value)
        )
    override val taskLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly] =
      scala
        .Option(impl.taskLogs())
        .map(value =>
          zio.aws.mwaa.model.ModuleLoggingConfigurationInput.wrap(value)
        )
    override val webserverLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly] =
      scala
        .Option(impl.webserverLogs())
        .map(value =>
          zio.aws.mwaa.model.ModuleLoggingConfigurationInput.wrap(value)
        )
    override val workerLogs
        : Option[zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly] =
      scala
        .Option(impl.workerLogs())
        .map(value =>
          zio.aws.mwaa.model.ModuleLoggingConfigurationInput.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.LoggingConfigurationInput
  ): zio.aws.mwaa.model.LoggingConfigurationInput.ReadOnly = new Wrapper(impl)
}
