package zio.aws.mwaa.model
import scala.jdk.CollectionConverters.*
sealed trait LoggingLevel {
  def unwrap: software.amazon.awssdk.services.mwaa.model.LoggingLevel
}
object LoggingLevel {
  def wrap(
      value: software.amazon.awssdk.services.mwaa.model.LoggingLevel
  ): zio.aws.mwaa.model.LoggingLevel = value match {
    case software.amazon.awssdk.services.mwaa.model.LoggingLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mwaa.model.LoggingLevel.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.mwaa.model.LoggingLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.mwaa.model.LoggingLevel.WARNING =>
      val r = WARNING
      r
    case software.amazon.awssdk.services.mwaa.model.LoggingLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.mwaa.model.LoggingLevel.DEBUG =>
      val r = DEBUG
      r
  }
  case object unknownToSdkVersion extends zio.aws.mwaa.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.LoggingLevel =
      software.amazon.awssdk.services.mwaa.model.LoggingLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.mwaa.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.LoggingLevel =
      software.amazon.awssdk.services.mwaa.model.LoggingLevel.CRITICAL
  }
  case object ERROR extends zio.aws.mwaa.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.LoggingLevel =
      software.amazon.awssdk.services.mwaa.model.LoggingLevel.ERROR
  }
  case object WARNING extends zio.aws.mwaa.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.LoggingLevel =
      software.amazon.awssdk.services.mwaa.model.LoggingLevel.WARNING
  }
  case object INFO extends zio.aws.mwaa.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.LoggingLevel =
      software.amazon.awssdk.services.mwaa.model.LoggingLevel.INFO
  }
  case object DEBUG extends zio.aws.mwaa.model.LoggingLevel {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.LoggingLevel =
      software.amazon.awssdk.services.mwaa.model.LoggingLevel.DEBUG
  }
}
