package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class MetricDatum(
    dimensions: Option[Iterable[zio.aws.mwaa.model.Dimension]] = None,
    metricName: String,
    statisticValues: Option[zio.aws.mwaa.model.StatisticSet] = None,
    timestamp: Timestamp,
    unit: Option[zio.aws.mwaa.model.Unit] = None,
    value: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.MetricDatum = {
    import MetricDatum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.MetricDatum
      .builder()
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .metricName(metricName: java.lang.String)
      .optionallyWith(statisticValues.map(value => value.buildAwsValue()))(
        _.statisticValues
      )
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(value.map(value => value: java.lang.Double))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.MetricDatum.ReadOnly =
    zio.aws.mwaa.model.MetricDatum.wrap(buildAwsValue())
}
object MetricDatum {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mwaa.model.MetricDatum] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.MetricDatum =
      zio.aws.mwaa.model.MetricDatum(
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricName,
        statisticValues.map(value => value.asEditable),
        timestamp,
        unit.map(value => value),
        value.map(value => value)
      )
    def dimensions: Option[List[zio.aws.mwaa.model.Dimension.ReadOnly]]
    def metricName: String
    def statisticValues: Option[zio.aws.mwaa.model.StatisticSet.ReadOnly]
    def timestamp: Timestamp
    def unit: Option[zio.aws.mwaa.model.Unit]
    def value: Option[Double]
    def getDimensions
        : ZIO[Any, AwsError, List[zio.aws.mwaa.model.Dimension.ReadOnly]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getMetricName: ZIO[Any, Nothing, String] = ZIO.succeed(metricName)
    def getStatisticValues
        : ZIO[Any, AwsError, zio.aws.mwaa.model.StatisticSet.ReadOnly] =
      AwsError.unwrapOptionField("statisticValues", statisticValues)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getUnit: ZIO[Any, AwsError, zio.aws.mwaa.model.Unit] =
      AwsError.unwrapOptionField("unit", unit)
    def getValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.MetricDatum
  ) extends zio.aws.mwaa.model.MetricDatum.ReadOnly {
    override val dimensions
        : Option[List[zio.aws.mwaa.model.Dimension.ReadOnly]] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mwaa.model.Dimension.wrap(item)
        }.toList
      )
    override val metricName: String = impl.metricName(): String
    override val statisticValues
        : Option[zio.aws.mwaa.model.StatisticSet.ReadOnly] = scala
      .Option(impl.statisticValues())
      .map(value => zio.aws.mwaa.model.StatisticSet.wrap(value))
    override val timestamp: Timestamp =
      zio.aws.mwaa.model.primitives.Timestamp(impl.timestamp())
    override val unit: Option[zio.aws.mwaa.model.Unit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.mwaa.model.Unit.wrap(value))
    override val value: Option[Double] =
      scala.Option(impl.value()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.MetricDatum
  ): zio.aws.mwaa.model.MetricDatum.ReadOnly = new Wrapper(impl)
}
