package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.{LoggingEnabled, CloudWatchLogGroupArn}
import scala.jdk.CollectionConverters.*
final case class ModuleLoggingConfiguration(
    cloudWatchLogGroupArn: Option[CloudWatchLogGroupArn] = None,
    enabled: Option[LoggingEnabled] = None,
    logLevel: Option[zio.aws.mwaa.model.LoggingLevel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfiguration = {
    import ModuleLoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfiguration
      .builder()
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          CloudWatchLogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(
        enabled.map(value => LoggingEnabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly =
    zio.aws.mwaa.model.ModuleLoggingConfiguration.wrap(buildAwsValue())
}
object ModuleLoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.ModuleLoggingConfiguration =
      zio.aws.mwaa.model.ModuleLoggingConfiguration(
        cloudWatchLogGroupArn.map(value => value),
        enabled.map(value => value),
        logLevel.map(value => value)
      )
    def cloudWatchLogGroupArn: Option[CloudWatchLogGroupArn]
    def enabled: Option[LoggingEnabled]
    def logLevel: Option[zio.aws.mwaa.model.LoggingLevel]
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, CloudWatchLogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getEnabled: ZIO[Any, AwsError, LoggingEnabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.mwaa.model.LoggingLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfiguration
  ) extends zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly {
    override val cloudWatchLogGroupArn: Option[CloudWatchLogGroupArn] = scala
      .Option(impl.cloudWatchLogGroupArn())
      .map(value => zio.aws.mwaa.model.primitives.CloudWatchLogGroupArn(value))
    override val enabled: Option[LoggingEnabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.mwaa.model.primitives.LoggingEnabled(value))
    override val logLevel: Option[zio.aws.mwaa.model.LoggingLevel] = scala
      .Option(impl.logLevel())
      .map(value => zio.aws.mwaa.model.LoggingLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfiguration
  ): zio.aws.mwaa.model.ModuleLoggingConfiguration.ReadOnly = new Wrapper(impl)
}
