package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mwaa.model.primitives.LoggingEnabled
import scala.jdk.CollectionConverters.*
final case class ModuleLoggingConfigurationInput(
    enabled: LoggingEnabled,
    logLevel: zio.aws.mwaa.model.LoggingLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfigurationInput = {
    import ModuleLoggingConfigurationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfigurationInput
      .builder()
      .enabled(LoggingEnabled.unwrap(enabled): java.lang.Boolean)
      .logLevel(logLevel.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly =
    zio.aws.mwaa.model.ModuleLoggingConfigurationInput.wrap(buildAwsValue())
}
object ModuleLoggingConfigurationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfigurationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.ModuleLoggingConfigurationInput =
      zio.aws.mwaa.model.ModuleLoggingConfigurationInput(enabled, logLevel)
    def enabled: LoggingEnabled
    def logLevel: zio.aws.mwaa.model.LoggingLevel
    def getEnabled: ZIO[Any, Nothing, LoggingEnabled] = ZIO.succeed(enabled)
    def getLogLevel: ZIO[Any, Nothing, zio.aws.mwaa.model.LoggingLevel] =
      ZIO.succeed(logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfigurationInput
  ) extends zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly {
    override val enabled: LoggingEnabled =
      zio.aws.mwaa.model.primitives.LoggingEnabled(impl.enabled())
    override val logLevel: zio.aws.mwaa.model.LoggingLevel =
      zio.aws.mwaa.model.LoggingLevel.wrap(impl.logLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfigurationInput
  ): zio.aws.mwaa.model.ModuleLoggingConfigurationInput.ReadOnly = new Wrapper(
    impl
  )
}
