package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.{SubnetId, SecurityGroupId}
import scala.jdk.CollectionConverters.*
final case class NetworkConfiguration(
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    subnetIds: Option[Iterable[SubnetId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.NetworkConfiguration = {
    import NetworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.NetworkConfiguration
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.NetworkConfiguration.ReadOnly =
    zio.aws.mwaa.model.NetworkConfiguration.wrap(buildAwsValue())
}
object NetworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.NetworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.NetworkConfiguration =
      zio.aws.mwaa.model.NetworkConfiguration(
        securityGroupIds.map(value => value),
        subnetIds.map(value => value)
      )
    def securityGroupIds: Option[List[SecurityGroupId]]
    def subnetIds: Option[List[SubnetId]]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.NetworkConfiguration
  ) extends zio.aws.mwaa.model.NetworkConfiguration.ReadOnly {
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mwaa.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mwaa.model.primitives.SubnetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.NetworkConfiguration
  ): zio.aws.mwaa.model.NetworkConfiguration.ReadOnly = new Wrapper(impl)
}
