package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mwaa.model.primitives.EnvironmentName
import scala.jdk.CollectionConverters.*
final case class PublishMetricsRequest(
    environmentName: EnvironmentName,
    metricData: Iterable[zio.aws.mwaa.model.MetricDatum]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.PublishMetricsRequest = {
    import PublishMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.PublishMetricsRequest
      .builder()
      .environmentName(
        EnvironmentName.unwrap(environmentName): java.lang.String
      )
      .metricData(metricData.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.PublishMetricsRequest.ReadOnly =
    zio.aws.mwaa.model.PublishMetricsRequest.wrap(buildAwsValue())
}
object PublishMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.PublishMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.PublishMetricsRequest =
      zio.aws.mwaa.model.PublishMetricsRequest(
        environmentName,
        metricData.map { item =>
          item.asEditable
        }
      )
    def environmentName: EnvironmentName
    def metricData: List[zio.aws.mwaa.model.MetricDatum.ReadOnly]
    def getEnvironmentName: ZIO[Any, Nothing, EnvironmentName] =
      ZIO.succeed(environmentName)
    def getMetricData
        : ZIO[Any, Nothing, List[zio.aws.mwaa.model.MetricDatum.ReadOnly]] =
      ZIO.succeed(metricData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.PublishMetricsRequest
  ) extends zio.aws.mwaa.model.PublishMetricsRequest.ReadOnly {
    override val environmentName: EnvironmentName =
      zio.aws.mwaa.model.primitives.EnvironmentName(impl.environmentName())
    override val metricData: List[zio.aws.mwaa.model.MetricDatum.ReadOnly] =
      impl
        .metricData()
        .asScala
        .map { item =>
          zio.aws.mwaa.model.MetricDatum.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.PublishMetricsRequest
  ): zio.aws.mwaa.model.PublishMetricsRequest.ReadOnly = new Wrapper(impl)
}
