package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class StatisticSet(
    maximum: Option[Double] = None,
    minimum: Option[Double] = None,
    sampleCount: Option[Integer] = None,
    sum: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.StatisticSet = {
    import StatisticSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.StatisticSet
      .builder()
      .optionallyWith(maximum.map(value => value: java.lang.Double))(_.maximum)
      .optionallyWith(minimum.map(value => value: java.lang.Double))(_.minimum)
      .optionallyWith(
        sampleCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.sampleCount)
      .optionallyWith(sum.map(value => value: java.lang.Double))(_.sum)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.StatisticSet.ReadOnly =
    zio.aws.mwaa.model.StatisticSet.wrap(buildAwsValue())
}
object StatisticSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mwaa.model.StatisticSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.StatisticSet =
      zio.aws.mwaa.model.StatisticSet(
        maximum.map(value => value),
        minimum.map(value => value),
        sampleCount.map(value => value),
        sum.map(value => value)
      )
    def maximum: Option[Double]
    def minimum: Option[Double]
    def sampleCount: Option[Integer]
    def sum: Option[Double]
    def getMaximum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getMinimum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getSampleCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sampleCount", sampleCount)
    def getSum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sum", sum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.StatisticSet
  ) extends zio.aws.mwaa.model.StatisticSet.ReadOnly {
    override val maximum: Option[Double] =
      scala.Option(impl.maximum()).map(value => value: Double)
    override val minimum: Option[Double] =
      scala.Option(impl.minimum()).map(value => value: Double)
    override val sampleCount: Option[Integer] = scala
      .Option(impl.sampleCount())
      .map(value => zio.aws.mwaa.model.primitives.Integer(value))
    override val sum: Option[Double] =
      scala.Option(impl.sum()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.StatisticSet
  ): zio.aws.mwaa.model.StatisticSet.ReadOnly = new Wrapper(impl)
}
