package zio.aws.mwaa.model
import scala.jdk.CollectionConverters.*
sealed trait Unit {
  def unwrap: software.amazon.awssdk.services.mwaa.model.Unit
}
object Unit {
  def wrap(
      value: software.amazon.awssdk.services.mwaa.model.Unit
  ): zio.aws.mwaa.model.Unit = value match {
    case software.amazon.awssdk.services.mwaa.model.Unit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.SECONDS =>
      val r = Seconds
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.MICROSECONDS =>
      val r = Microseconds
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.MILLISECONDS =>
      val r = Milliseconds
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.BYTES =>
      val r = Bytes
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.KILOBYTES =>
      val r = Kilobytes
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.MEGABYTES =>
      val r = Megabytes
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.GIGABYTES =>
      val r = Gigabytes
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.TERABYTES =>
      val r = Terabytes
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.BITS =>
      val r = Bits
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.KILOBITS =>
      val r = Kilobits
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.MEGABITS =>
      val r = Megabits
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.GIGABITS =>
      val r = Gigabits
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.TERABITS =>
      val r = Terabits
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.PERCENT =>
      val r = Percent
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.COUNT =>
      val r = Count
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.BYTES_SECOND =>
      val r = `Bytes/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.KILOBYTES_SECOND =>
      val r = `Kilobytes/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.MEGABYTES_SECOND =>
      val r = `Megabytes/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.GIGABYTES_SECOND =>
      val r = `Gigabytes/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.TERABYTES_SECOND =>
      val r = `Terabytes/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.BITS_SECOND =>
      val r = `Bits/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.KILOBITS_SECOND =>
      val r = `Kilobits/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.MEGABITS_SECOND =>
      val r = `Megabits/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.GIGABITS_SECOND =>
      val r = `Gigabits/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.TERABITS_SECOND =>
      val r = `Terabits/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.COUNT_SECOND =>
      val r = `Count/Second`
      r
    case software.amazon.awssdk.services.mwaa.model.Unit.NONE =>
      val r = None
      r
  }
  case object unknownToSdkVersion extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.UNKNOWN_TO_SDK_VERSION
  }
  case object Seconds extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.SECONDS
  }
  case object Microseconds extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.MICROSECONDS
  }
  case object Milliseconds extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.MILLISECONDS
  }
  case object Bytes extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.BYTES
  }
  case object Kilobytes extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.KILOBYTES
  }
  case object Megabytes extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.MEGABYTES
  }
  case object Gigabytes extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.GIGABYTES
  }
  case object Terabytes extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.TERABYTES
  }
  case object Bits extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.BITS
  }
  case object Kilobits extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.KILOBITS
  }
  case object Megabits extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.MEGABITS
  }
  case object Gigabits extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.GIGABITS
  }
  case object Terabits extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.TERABITS
  }
  case object Percent extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.PERCENT
  }
  case object Count extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.COUNT
  }
  case object `Bytes/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.BYTES_SECOND
  }
  case object `Kilobytes/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.KILOBYTES_SECOND
  }
  case object `Megabytes/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.MEGABYTES_SECOND
  }
  case object `Gigabytes/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.GIGABYTES_SECOND
  }
  case object `Terabytes/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.TERABYTES_SECOND
  }
  case object `Bits/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.BITS_SECOND
  }
  case object `Kilobits/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.KILOBITS_SECOND
  }
  case object `Megabits/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.MEGABITS_SECOND
  }
  case object `Gigabits/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.GIGABITS_SECOND
  }
  case object `Terabits/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.TERABITS_SECOND
  }
  case object `Count/Second` extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.COUNT_SECOND
  }
  case object None extends zio.aws.mwaa.model.Unit {
    override def unwrap: software.amazon.awssdk.services.mwaa.model.Unit =
      software.amazon.awssdk.services.mwaa.model.Unit.NONE
  }
}
