package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mwaa.model.primitives.{TagKey, EnvironmentArn}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: EnvironmentArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.UntagResourceRequest
      .builder()
      .resourceArn(EnvironmentArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.UntagResourceRequest.ReadOnly =
    zio.aws.mwaa.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.UntagResourceRequest =
      zio.aws.mwaa.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: EnvironmentArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, EnvironmentArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.UntagResourceRequest
  ) extends zio.aws.mwaa.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: EnvironmentArn =
      zio.aws.mwaa.model.primitives.EnvironmentArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.mwaa.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.UntagResourceRequest
  ): zio.aws.mwaa.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
