package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.EnvironmentArn
import scala.jdk.CollectionConverters.*
final case class UpdateEnvironmentResponse(arn: Option[EnvironmentArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.UpdateEnvironmentResponse = {
    import UpdateEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.UpdateEnvironmentResponse
      .builder()
      .optionallyWith(
        arn.map(value => EnvironmentArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.UpdateEnvironmentResponse.ReadOnly =
    zio.aws.mwaa.model.UpdateEnvironmentResponse.wrap(buildAwsValue())
}
object UpdateEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.UpdateEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.UpdateEnvironmentResponse =
      zio.aws.mwaa.model.UpdateEnvironmentResponse(arn.map(value => value))
    def arn: Option[EnvironmentArn]
    def getArn: ZIO[Any, AwsError, EnvironmentArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.UpdateEnvironmentResponse
  ) extends zio.aws.mwaa.model.UpdateEnvironmentResponse.ReadOnly {
    override val arn: Option[EnvironmentArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mwaa.model.primitives.EnvironmentArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.UpdateEnvironmentResponse
  ): zio.aws.mwaa.model.UpdateEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
