package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mwaa.model.primitives.{ErrorMessage, ErrorCode}
import scala.jdk.CollectionConverters.*
final case class UpdateError(
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.UpdateError = {
    import UpdateError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.UpdateError
      .builder()
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.UpdateError.ReadOnly =
    zio.aws.mwaa.model.UpdateError.wrap(buildAwsValue())
}
object UpdateError {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mwaa.model.UpdateError] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.UpdateError =
      zio.aws.mwaa.model.UpdateError(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.UpdateError
  ) extends zio.aws.mwaa.model.UpdateError.ReadOnly {
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.mwaa.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.mwaa.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.UpdateError
  ): zio.aws.mwaa.model.UpdateError.ReadOnly = new Wrapper(impl)
}
