package zio.aws.mwaa.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mwaa.model.primitives.SecurityGroupId
import scala.jdk.CollectionConverters.*
final case class UpdateNetworkConfigurationInput(
    securityGroupIds: Iterable[SecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mwaa.model.UpdateNetworkConfigurationInput = {
    import UpdateNetworkConfigurationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mwaa.model.UpdateNetworkConfigurationInput
      .builder()
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mwaa.model.UpdateNetworkConfigurationInput.ReadOnly =
    zio.aws.mwaa.model.UpdateNetworkConfigurationInput.wrap(buildAwsValue())
}
object UpdateNetworkConfigurationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mwaa.model.UpdateNetworkConfigurationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mwaa.model.UpdateNetworkConfigurationInput =
      zio.aws.mwaa.model.UpdateNetworkConfigurationInput(securityGroupIds)
    def securityGroupIds: List[SecurityGroupId]
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mwaa.model.UpdateNetworkConfigurationInput
  ) extends zio.aws.mwaa.model.UpdateNetworkConfigurationInput.ReadOnly {
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.mwaa.model.primitives.SecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mwaa.model.UpdateNetworkConfigurationInput
  ): zio.aws.mwaa.model.UpdateNetworkConfigurationInput.ReadOnly = new Wrapper(
    impl
  )
}
