package zio.aws.mwaa.model
import scala.jdk.CollectionConverters.*
sealed trait UpdateStatus {
  def unwrap: software.amazon.awssdk.services.mwaa.model.UpdateStatus
}
object UpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.mwaa.model.UpdateStatus
  ): zio.aws.mwaa.model.UpdateStatus = value match {
    case software.amazon.awssdk.services.mwaa.model.UpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mwaa.model.UpdateStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.mwaa.model.UpdateStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.mwaa.model.UpdateStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.mwaa.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.UpdateStatus =
      software.amazon.awssdk.services.mwaa.model.UpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.mwaa.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.UpdateStatus =
      software.amazon.awssdk.services.mwaa.model.UpdateStatus.SUCCESS
  }
  case object PENDING extends zio.aws.mwaa.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.UpdateStatus =
      software.amazon.awssdk.services.mwaa.model.UpdateStatus.PENDING
  }
  case object FAILED extends zio.aws.mwaa.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.UpdateStatus =
      software.amazon.awssdk.services.mwaa.model.UpdateStatus.FAILED
  }
}
