package zio.aws.mwaa.model
import scala.jdk.CollectionConverters.*
sealed trait WebserverAccessMode {
  def unwrap: software.amazon.awssdk.services.mwaa.model.WebserverAccessMode
}
object WebserverAccessMode {
  def wrap(
      value: software.amazon.awssdk.services.mwaa.model.WebserverAccessMode
  ): zio.aws.mwaa.model.WebserverAccessMode = value match {
    case software.amazon.awssdk.services.mwaa.model.WebserverAccessMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mwaa.model.WebserverAccessMode.PRIVATE_ONLY =>
      val r = PRIVATE_ONLY
      r
    case software.amazon.awssdk.services.mwaa.model.WebserverAccessMode.PUBLIC_ONLY =>
      val r = PUBLIC_ONLY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mwaa.model.WebserverAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.WebserverAccessMode =
      software.amazon.awssdk.services.mwaa.model.WebserverAccessMode.UNKNOWN_TO_SDK_VERSION
  }
  case object PRIVATE_ONLY extends zio.aws.mwaa.model.WebserverAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.WebserverAccessMode =
      software.amazon.awssdk.services.mwaa.model.WebserverAccessMode.PRIVATE_ONLY
  }
  case object PUBLIC_ONLY extends zio.aws.mwaa.model.WebserverAccessMode {
    override def unwrap
        : software.amazon.awssdk.services.mwaa.model.WebserverAccessMode =
      software.amazon.awssdk.services.mwaa.model.WebserverAccessMode.PUBLIC_ONLY
  }
}
