package zio.aws.mwaa
import zio.prelude.Subtype
import zio.aws.mwaa.model.primitives.{
  SubnetId,
  SecurityGroupId,
  ConfigValue,
  TagValue,
  EnvironmentName,
  ConfigKey,
  TagKey
}
import java.time.Instant
import zio.aws.mwaa.model.primitives.TagKey.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AirflowVersion extends Subtype[String]
    type AirflowVersion = zio.aws.mwaa.model.primitives.AirflowVersion.Type
    object CloudWatchLogGroupArn extends Subtype[String]
    type CloudWatchLogGroupArn =
      zio.aws.mwaa.model.primitives.CloudWatchLogGroupArn.Type
    object ConfigKey extends Subtype[String]
    type ConfigKey = zio.aws.mwaa.model.primitives.ConfigKey.Type
    object ConfigValue extends Subtype[String]
    type ConfigValue = zio.aws.mwaa.model.primitives.ConfigValue.Type
    object CreatedAt extends Subtype[Instant]
    type CreatedAt = zio.aws.mwaa.model.primitives.CreatedAt.Type
    object EnvironmentArn extends Subtype[String]
    type EnvironmentArn = zio.aws.mwaa.model.primitives.EnvironmentArn.Type
    object EnvironmentClass extends Subtype[String]
    type EnvironmentClass = zio.aws.mwaa.model.primitives.EnvironmentClass.Type
    object EnvironmentName extends Subtype[String]
    type EnvironmentName = zio.aws.mwaa.model.primitives.EnvironmentName.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.mwaa.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.mwaa.model.primitives.ErrorMessage.Type
    object Hostname extends Subtype[String]
    type Hostname = zio.aws.mwaa.model.primitives.Hostname.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn = zio.aws.mwaa.model.primitives.IamRoleArn.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.mwaa.model.primitives.Integer.Type
    object KmsKey extends Subtype[String]
    type KmsKey = zio.aws.mwaa.model.primitives.KmsKey.Type
    object ListEnvironmentsInputMaxResultsInteger extends Subtype[Int]
    type ListEnvironmentsInputMaxResultsInteger =
      zio.aws.mwaa.model.primitives.ListEnvironmentsInputMaxResultsInteger.Type
    object LoggingEnabled extends Subtype[Boolean]
    type LoggingEnabled = zio.aws.mwaa.model.primitives.LoggingEnabled.Type
    object MaxWorkers extends Subtype[Int]
    type MaxWorkers = zio.aws.mwaa.model.primitives.MaxWorkers.Type
    object MinWorkers extends Subtype[Int]
    type MinWorkers = zio.aws.mwaa.model.primitives.MinWorkers.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.mwaa.model.primitives.NextToken.Type
    object RelativePath extends Subtype[String]
    type RelativePath = zio.aws.mwaa.model.primitives.RelativePath.Type
    object S3BucketArn extends Subtype[String]
    type S3BucketArn = zio.aws.mwaa.model.primitives.S3BucketArn.Type
    object S3ObjectVersion extends Subtype[String]
    type S3ObjectVersion = zio.aws.mwaa.model.primitives.S3ObjectVersion.Type
    object Schedulers extends Subtype[Int]
    type Schedulers = zio.aws.mwaa.model.primitives.Schedulers.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId = zio.aws.mwaa.model.primitives.SecurityGroupId.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.mwaa.model.primitives.SubnetId.Type
    object SyntheticCreateCliTokenResponseToken extends Subtype[String]
    type SyntheticCreateCliTokenResponseToken =
      zio.aws.mwaa.model.primitives.SyntheticCreateCliTokenResponseToken.Type
    object SyntheticCreateWebLoginTokenResponseToken extends Subtype[String]
    type SyntheticCreateWebLoginTokenResponseToken =
      zio.aws.mwaa.model.primitives.SyntheticCreateWebLoginTokenResponseToken.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.mwaa.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.mwaa.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.mwaa.model.primitives.Timestamp.Type
    object UpdateCreatedAt extends Subtype[Instant]
    type UpdateCreatedAt = zio.aws.mwaa.model.primitives.UpdateCreatedAt.Type
    object WebserverUrl extends Subtype[String]
    type WebserverUrl = zio.aws.mwaa.model.primitives.WebserverUrl.Type
    object WeeklyMaintenanceWindowStart extends Subtype[String]
    type WeeklyMaintenanceWindowStart =
      zio.aws.mwaa.model.primitives.WeeklyMaintenanceWindowStart.Type
  }
  type AirflowConfigurationOptions = Map[ConfigKey, ConfigValue]
  type Dimensions = List[zio.aws.mwaa.model.Dimension]
  type EnvironmentList = List[EnvironmentName]
  type MetricData = List[zio.aws.mwaa.model.MetricDatum]
  type SecurityGroupList = List[SecurityGroupId]
  type SubnetList = List[SubnetId]
  type SyntheticCreateEnvironmentInputAirflowConfigurationOptions =
    Map[ConfigKey, ConfigValue]
  type SyntheticUpdateEnvironmentInputAirflowConfigurationOptions =
    Map[ConfigKey, ConfigValue]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
