package zio.aws.neptune
import zio.aws.neptune.model.DescribeValidDbInstanceModificationsResponse.ReadOnly
import zio.aws.neptune.model.{
  DescribeEventCategoriesRequest,
  ResetDbParameterGroupRequest,
  DescribeDbClusterSnapshotsRequest,
  PromoteReadReplicaDbClusterRequest,
  ModifyEventSubscriptionRequest,
  AddRoleToDbClusterRequest,
  DeleteDbSubnetGroupRequest,
  DescribeDbClusterEndpointsRequest,
  ModifyDbClusterSnapshotAttributeRequest,
  DescribeEngineDefaultParametersRequest,
  ModifyGlobalClusterRequest,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  CreateDbClusterEndpointRequest,
  DeleteDbClusterRequest,
  DescribeValidDbInstanceModificationsRequest,
  RestoreDbClusterFromSnapshotRequest,
  DeleteGlobalClusterRequest,
  CopyDbClusterSnapshotRequest,
  DeleteDbClusterSnapshotRequest,
  ModifyDbParameterGroupRequest,
  DescribeEventsRequest,
  FailoverGlobalClusterRequest,
  CreateDbParameterGroupRequest,
  DescribeDbInstancesRequest,
  ApplyPendingMaintenanceActionRequest,
  DescribeDbEngineVersionsRequest,
  ListTagsForResourceRequest,
  DeleteEventSubscriptionRequest,
  ModifyDbClusterParameterGroupRequest,
  DescribeDbClusterSnapshotAttributesRequest,
  StartDbClusterRequest,
  DescribeDbClustersRequest,
  CreateGlobalClusterRequest,
  CreateDbSubnetGroupRequest,
  FailoverDbClusterRequest,
  CreateDbClusterRequest,
  ModifyDbClusterRequest,
  CopyDbParameterGroupRequest,
  RemoveFromGlobalClusterRequest,
  ModifyDbInstanceRequest,
  DescribeDbClusterParametersRequest,
  RemoveTagsFromResourceRequest,
  ModifyDbClusterEndpointRequest,
  DescribePendingMaintenanceActionsRequest,
  ModifyDbSubnetGroupRequest,
  DescribeDbClusterParameterGroupsRequest,
  DeleteDbClusterEndpointRequest,
  CopyDbClusterParameterGroupRequest,
  StopDbClusterRequest,
  DeleteDbClusterParameterGroupRequest,
  RemoveSourceIdentifierFromSubscriptionRequest,
  RestoreDbClusterToPointInTimeRequest,
  DeleteDbInstanceRequest,
  CreateDbInstanceRequest,
  DescribeDbSubnetGroupsRequest,
  DescribeEngineDefaultClusterParametersRequest,
  ResetDbClusterParameterGroupRequest,
  RebootDbInstanceRequest,
  DescribeOrderableDbInstanceOptionsRequest,
  DescribeGlobalClustersRequest,
  DescribeDbParameterGroupsRequest,
  DescribeEventSubscriptionsRequest,
  DeleteDbParameterGroupRequest,
  AddSourceIdentifierToSubscriptionRequest,
  RemoveRoleFromDbClusterRequest,
  CreateDbClusterParameterGroupRequest,
  CreateDbClusterSnapshotRequest,
  DescribeDbParametersRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient
object NeptuneMock extends Mock[Neptune] {
  object CopyDBClusterSnapshot
      extends Effect[
        CopyDbClusterSnapshotRequest,
        AwsError,
        zio.aws.neptune.model.CopyDbClusterSnapshotResponse.ReadOnly
      ]
  object DescribeEngineDefaultParameters
      extends Effect[
        DescribeEngineDefaultParametersRequest,
        AwsError,
        zio.aws.neptune.model.DescribeEngineDefaultParametersResponse.ReadOnly
      ]
  object ModifyDBInstance
      extends Effect[
        ModifyDbInstanceRequest,
        AwsError,
        zio.aws.neptune.model.ModifyDbInstanceResponse.ReadOnly
      ]
  object DescribeDBClusterEndpoints
      extends Stream[
        DescribeDbClusterEndpointsRequest,
        AwsError,
        zio.aws.neptune.model.DBClusterEndpoint.ReadOnly
      ]
  object DescribeDBClusterEndpointsPaginated
      extends Effect[
        DescribeDbClusterEndpointsRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbClusterEndpointsResponse.ReadOnly
      ]
  object FailoverGlobalCluster
      extends Effect[
        FailoverGlobalClusterRequest,
        AwsError,
        zio.aws.neptune.model.FailoverGlobalClusterResponse.ReadOnly
      ]
  object DescribeDBParameters
      extends Stream[
        DescribeDbParametersRequest,
        AwsError,
        zio.aws.neptune.model.Parameter.ReadOnly
      ]
  object DescribeDBParametersPaginated
      extends Effect[
        DescribeDbParametersRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbParametersResponse.ReadOnly
      ]
  object AddTagsToResource
      extends Effect[AddTagsToResourceRequest, AwsError, Unit]
  object DescribeDBClusterSnapshots
      extends Stream[
        DescribeDbClusterSnapshotsRequest,
        AwsError,
        zio.aws.neptune.model.DBClusterSnapshot.ReadOnly
      ]
  object DescribeDBClusterSnapshotsPaginated
      extends Effect[
        DescribeDbClusterSnapshotsRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse.ReadOnly
      ]
  object ResetDBClusterParameterGroup
      extends Effect[
        ResetDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.neptune.model.ResetDbClusterParameterGroupResponse.ReadOnly
      ]
  object RemoveSourceIdentifierFromSubscription
      extends Effect[
        RemoveSourceIdentifierFromSubscriptionRequest,
        AwsError,
        zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
      ]
  object DescribeEngineDefaultClusterParameters
      extends Effect[
        DescribeEngineDefaultClusterParametersRequest,
        AwsError,
        zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
      ]
  object CreateDBSubnetGroup
      extends Effect[
        CreateDbSubnetGroupRequest,
        AwsError,
        zio.aws.neptune.model.CreateDbSubnetGroupResponse.ReadOnly
      ]
  object CreateDBClusterEndpoint
      extends Effect[
        CreateDbClusterEndpointRequest,
        AwsError,
        zio.aws.neptune.model.CreateDbClusterEndpointResponse.ReadOnly
      ]
  object AddRoleToDBCluster
      extends Effect[AddRoleToDbClusterRequest, AwsError, Unit]
  object CopyDBClusterParameterGroup
      extends Effect[
        CopyDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.neptune.model.CopyDbClusterParameterGroupResponse.ReadOnly
      ]
  object DescribePendingMaintenanceActions
      extends Stream[
        DescribePendingMaintenanceActionsRequest,
        AwsError,
        zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly
      ]
  object DescribePendingMaintenanceActionsPaginated
      extends Effect[
        DescribePendingMaintenanceActionsRequest,
        AwsError,
        zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse.ReadOnly
      ]
  object DeleteDBClusterEndpoint
      extends Effect[
        DeleteDbClusterEndpointRequest,
        AwsError,
        zio.aws.neptune.model.DeleteDbClusterEndpointResponse.ReadOnly
      ]
  object DeleteDBClusterParameterGroup
      extends Effect[DeleteDbClusterParameterGroupRequest, AwsError, Unit]
  object RemoveFromGlobalCluster
      extends Effect[
        RemoveFromGlobalClusterRequest,
        AwsError,
        zio.aws.neptune.model.RemoveFromGlobalClusterResponse.ReadOnly
      ]
  object ModifyDBClusterParameterGroup
      extends Effect[
        ModifyDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse.ReadOnly
      ]
  object StopDBCluster
      extends Effect[
        StopDbClusterRequest,
        AwsError,
        zio.aws.neptune.model.StopDbClusterResponse.ReadOnly
      ]
  object CreateDBCluster
      extends Effect[
        CreateDbClusterRequest,
        AwsError,
        zio.aws.neptune.model.CreateDbClusterResponse.ReadOnly
      ]
  object DeleteEventSubscription
      extends Effect[
        DeleteEventSubscriptionRequest,
        AwsError,
        zio.aws.neptune.model.DeleteEventSubscriptionResponse.ReadOnly
      ]
  object DeleteDBParameterGroup
      extends Effect[DeleteDbParameterGroupRequest, AwsError, Unit]
  object DescribeDBSubnetGroups
      extends Stream[
        DescribeDbSubnetGroupsRequest,
        AwsError,
        zio.aws.neptune.model.DBSubnetGroup.ReadOnly
      ]
  object DescribeDBSubnetGroupsPaginated
      extends Effect[
        DescribeDbSubnetGroupsRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.ReadOnly
      ]
  object RemoveRoleFromDBCluster
      extends Effect[RemoveRoleFromDbClusterRequest, AwsError, Unit]
  object CreateDBClusterParameterGroup
      extends Effect[
        CreateDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.neptune.model.CreateDbClusterParameterGroupResponse.ReadOnly
      ]
  object ModifyDBCluster
      extends Effect[
        ModifyDbClusterRequest,
        AwsError,
        zio.aws.neptune.model.ModifyDbClusterResponse.ReadOnly
      ]
  object DescribeValidDBInstanceModifications
      extends Effect[
        DescribeValidDbInstanceModificationsRequest,
        AwsError,
        ReadOnly
      ]
  object ResetDBParameterGroup
      extends Effect[
        ResetDbParameterGroupRequest,
        AwsError,
        zio.aws.neptune.model.ResetDbParameterGroupResponse.ReadOnly
      ]
  object RemoveTagsFromResource
      extends Effect[RemoveTagsFromResourceRequest, AwsError, Unit]
  object CreateDBParameterGroup
      extends Effect[
        CreateDbParameterGroupRequest,
        AwsError,
        zio.aws.neptune.model.CreateDbParameterGroupResponse.ReadOnly
      ]
  object ApplyPendingMaintenanceAction
      extends Effect[
        ApplyPendingMaintenanceActionRequest,
        AwsError,
        zio.aws.neptune.model.ApplyPendingMaintenanceActionResponse.ReadOnly
      ]
  object ModifyDBSubnetGroup
      extends Effect[
        ModifyDbSubnetGroupRequest,
        AwsError,
        zio.aws.neptune.model.ModifyDbSubnetGroupResponse.ReadOnly
      ]
  object ModifyGlobalCluster
      extends Effect[
        ModifyGlobalClusterRequest,
        AwsError,
        zio.aws.neptune.model.ModifyGlobalClusterResponse.ReadOnly
      ]
  object RestoreDBClusterFromSnapshot
      extends Effect[
        RestoreDbClusterFromSnapshotRequest,
        AwsError,
        zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
      ]
  object DescribeGlobalClusters
      extends Stream[
        DescribeGlobalClustersRequest,
        AwsError,
        zio.aws.neptune.model.GlobalCluster.ReadOnly
      ]
  object DescribeGlobalClustersPaginated
      extends Effect[
        DescribeGlobalClustersRequest,
        AwsError,
        zio.aws.neptune.model.DescribeGlobalClustersResponse.ReadOnly
      ]
  object DescribeDBClusterParameters
      extends Stream[
        DescribeDbClusterParametersRequest,
        AwsError,
        zio.aws.neptune.model.Parameter.ReadOnly
      ]
  object DescribeDBClusterParametersPaginated
      extends Effect[
        DescribeDbClusterParametersRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbClusterParametersResponse.ReadOnly
      ]
  object CopyDBParameterGroup
      extends Effect[
        CopyDbParameterGroupRequest,
        AwsError,
        zio.aws.neptune.model.CopyDbParameterGroupResponse.ReadOnly
      ]
  object ModifyEventSubscription
      extends Effect[
        ModifyEventSubscriptionRequest,
        AwsError,
        zio.aws.neptune.model.ModifyEventSubscriptionResponse.ReadOnly
      ]
  object ModifyDBParameterGroup
      extends Effect[
        ModifyDbParameterGroupRequest,
        AwsError,
        zio.aws.neptune.model.ModifyDbParameterGroupResponse.ReadOnly
      ]
  object CreateDBInstance
      extends Effect[
        CreateDbInstanceRequest,
        AwsError,
        zio.aws.neptune.model.CreateDbInstanceResponse.ReadOnly
      ]
  object DeleteDBClusterSnapshot
      extends Effect[
        DeleteDbClusterSnapshotRequest,
        AwsError,
        zio.aws.neptune.model.DeleteDbClusterSnapshotResponse.ReadOnly
      ]
  object StartDBCluster
      extends Effect[
        StartDbClusterRequest,
        AwsError,
        zio.aws.neptune.model.StartDbClusterResponse.ReadOnly
      ]
  object ModifyDBClusterSnapshotAttribute
      extends Effect[
        ModifyDbClusterSnapshotAttributeRequest,
        AwsError,
        zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
      ]
  object DescribeEventCategories
      extends Effect[
        DescribeEventCategoriesRequest,
        AwsError,
        zio.aws.neptune.model.DescribeEventCategoriesResponse.ReadOnly
      ]
  object DeleteDBSubnetGroup
      extends Effect[DeleteDbSubnetGroupRequest, AwsError, Unit]
  object ModifyDBClusterEndpoint
      extends Effect[
        ModifyDbClusterEndpointRequest,
        AwsError,
        zio.aws.neptune.model.ModifyDbClusterEndpointResponse.ReadOnly
      ]
  object PromoteReadReplicaDBCluster
      extends Effect[
        PromoteReadReplicaDbClusterRequest,
        AwsError,
        zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse.ReadOnly
      ]
  object RebootDBInstance
      extends Effect[
        RebootDbInstanceRequest,
        AwsError,
        zio.aws.neptune.model.RebootDbInstanceResponse.ReadOnly
      ]
  object DescribeDBClusterParameterGroups
      extends Stream[
        DescribeDbClusterParameterGroupsRequest,
        AwsError,
        zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly
      ]
  object DescribeDBClusterParameterGroupsPaginated
      extends Effect[
        DescribeDbClusterParameterGroupsRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
      ]
  object CreateEventSubscription
      extends Effect[
        CreateEventSubscriptionRequest,
        AwsError,
        zio.aws.neptune.model.CreateEventSubscriptionResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.neptune.model.ListTagsForResourceResponse.ReadOnly
      ]
  object RestoreDBClusterToPointInTime
      extends Effect[
        RestoreDbClusterToPointInTimeRequest,
        AwsError,
        zio.aws.neptune.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
      ]
  object DescribeDBClusters
      extends Stream[
        DescribeDbClustersRequest,
        AwsError,
        zio.aws.neptune.model.DBCluster.ReadOnly
      ]
  object DescribeDBClustersPaginated
      extends Effect[
        DescribeDbClustersRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbClustersResponse.ReadOnly
      ]
  object FailoverDBCluster
      extends Effect[
        FailoverDbClusterRequest,
        AwsError,
        zio.aws.neptune.model.FailoverDbClusterResponse.ReadOnly
      ]
  object DescribeEventSubscriptions
      extends Stream[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.neptune.model.EventSubscription.ReadOnly
      ]
  object DescribeEventSubscriptionsPaginated
      extends Effect[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.neptune.model.DescribeEventSubscriptionsResponse.ReadOnly
      ]
  object DescribeDBInstances
      extends Stream[
        DescribeDbInstancesRequest,
        AwsError,
        zio.aws.neptune.model.DBInstance.ReadOnly
      ]
  object DescribeDBInstancesPaginated
      extends Effect[
        DescribeDbInstancesRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbInstancesResponse.ReadOnly
      ]
  object CreateDBClusterSnapshot
      extends Effect[
        CreateDbClusterSnapshotRequest,
        AwsError,
        zio.aws.neptune.model.CreateDbClusterSnapshotResponse.ReadOnly
      ]
  object DeleteDBCluster
      extends Effect[
        DeleteDbClusterRequest,
        AwsError,
        zio.aws.neptune.model.DeleteDbClusterResponse.ReadOnly
      ]
  object DeleteGlobalCluster
      extends Effect[
        DeleteGlobalClusterRequest,
        AwsError,
        zio.aws.neptune.model.DeleteGlobalClusterResponse.ReadOnly
      ]
  object DeleteDBInstance
      extends Effect[
        DeleteDbInstanceRequest,
        AwsError,
        zio.aws.neptune.model.DeleteDbInstanceResponse.ReadOnly
      ]
  object AddSourceIdentifierToSubscription
      extends Effect[
        AddSourceIdentifierToSubscriptionRequest,
        AwsError,
        zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
      ]
  object DescribeDBEngineVersions
      extends Stream[
        DescribeDbEngineVersionsRequest,
        AwsError,
        zio.aws.neptune.model.DBEngineVersion.ReadOnly
      ]
  object DescribeDBEngineVersionsPaginated
      extends Effect[
        DescribeDbEngineVersionsRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbEngineVersionsResponse.ReadOnly
      ]
  object CreateGlobalCluster
      extends Effect[
        CreateGlobalClusterRequest,
        AwsError,
        zio.aws.neptune.model.CreateGlobalClusterResponse.ReadOnly
      ]
  object DescribeOrderableDBInstanceOptions
      extends Stream[
        DescribeOrderableDbInstanceOptionsRequest,
        AwsError,
        zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly
      ]
  object DescribeOrderableDBInstanceOptionsPaginated
      extends Effect[
        DescribeOrderableDbInstanceOptionsRequest,
        AwsError,
        zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
      ]
  object DescribeDBClusterSnapshotAttributes
      extends Effect[
        DescribeDbClusterSnapshotAttributesRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[
        DescribeEventsRequest,
        AwsError,
        zio.aws.neptune.model.Event.ReadOnly
      ]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.neptune.model.DescribeEventsResponse.ReadOnly
      ]
  object DescribeDBParameterGroups
      extends Stream[
        DescribeDbParameterGroupsRequest,
        AwsError,
        zio.aws.neptune.model.DBParameterGroup.ReadOnly
      ]
  object DescribeDBParameterGroupsPaginated
      extends Effect[
        DescribeDbParameterGroupsRequest,
        AwsError,
        zio.aws.neptune.model.DescribeDbParameterGroupsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Neptune] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Neptune] { rts =>
        zio.ZIO.succeed {
          new Neptune {
            val api: NeptuneAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Neptune = this
            def copyDBClusterSnapshot(
                request: CopyDbClusterSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.CopyDbClusterSnapshotResponse.ReadOnly
            ] = proxy(CopyDBClusterSnapshot, request)
            def describeEngineDefaultParameters(
                request: DescribeEngineDefaultParametersRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeEngineDefaultParametersResponse.ReadOnly
            ] = proxy(DescribeEngineDefaultParameters, request)
            def modifyDBInstance(request: ModifyDbInstanceRequest): IO[
              AwsError,
              zio.aws.neptune.model.ModifyDbInstanceResponse.ReadOnly
            ] = proxy(ModifyDBInstance, request)
            def describeDBClusterEndpoints(
                request: DescribeDbClusterEndpointsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.DBClusterEndpoint.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBClusterEndpoints, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBClusterEndpointsPaginated(
                request: DescribeDbClusterEndpointsRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbClusterEndpointsResponse.ReadOnly
            ] = proxy(DescribeDBClusterEndpointsPaginated, request)
            def failoverGlobalCluster(
                request: FailoverGlobalClusterRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.FailoverGlobalClusterResponse.ReadOnly
            ] = proxy(FailoverGlobalCluster, request)
            def describeDBParameters(
                request: DescribeDbParametersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.Parameter.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBParameters, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBParametersPaginated(
                request: DescribeDbParametersRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbParametersResponse.ReadOnly
            ] = proxy(DescribeDBParametersPaginated, request)
            def addTagsToResource(
                request: AddTagsToResourceRequest
            ): IO[AwsError, Unit] = proxy(AddTagsToResource, request)
            def describeDBClusterSnapshots(
                request: DescribeDbClusterSnapshotsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.DBClusterSnapshot.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBClusterSnapshots, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBClusterSnapshotsPaginated(
                request: DescribeDbClusterSnapshotsRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse.ReadOnly
            ] = proxy(DescribeDBClusterSnapshotsPaginated, request)
            def resetDBClusterParameterGroup(
                request: ResetDbClusterParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.ResetDbClusterParameterGroupResponse.ReadOnly
            ] = proxy(ResetDBClusterParameterGroup, request)
            def removeSourceIdentifierFromSubscription(
                request: RemoveSourceIdentifierFromSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
            ] = proxy(RemoveSourceIdentifierFromSubscription, request)
            def describeEngineDefaultClusterParameters(
                request: DescribeEngineDefaultClusterParametersRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
            ] = proxy(DescribeEngineDefaultClusterParameters, request)
            def createDBSubnetGroup(request: CreateDbSubnetGroupRequest): IO[
              AwsError,
              zio.aws.neptune.model.CreateDbSubnetGroupResponse.ReadOnly
            ] = proxy(CreateDBSubnetGroup, request)
            def createDBClusterEndpoint(
                request: CreateDbClusterEndpointRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.CreateDbClusterEndpointResponse.ReadOnly
            ] = proxy(CreateDBClusterEndpoint, request)
            def addRoleToDBCluster(
                request: AddRoleToDbClusterRequest
            ): IO[AwsError, Unit] = proxy(AddRoleToDBCluster, request)
            def copyDBClusterParameterGroup(
                request: CopyDbClusterParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.CopyDbClusterParameterGroupResponse.ReadOnly
            ] = proxy(CopyDBClusterParameterGroup, request)
            def describePendingMaintenanceActions(
                request: DescribePendingMaintenanceActionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribePendingMaintenanceActions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describePendingMaintenanceActionsPaginated(
                request: DescribePendingMaintenanceActionsRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse.ReadOnly
            ] = proxy(DescribePendingMaintenanceActionsPaginated, request)
            def deleteDBClusterEndpoint(
                request: DeleteDbClusterEndpointRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DeleteDbClusterEndpointResponse.ReadOnly
            ] = proxy(DeleteDBClusterEndpoint, request)
            def deleteDBClusterParameterGroup(
                request: DeleteDbClusterParameterGroupRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteDBClusterParameterGroup, request)
            def removeFromGlobalCluster(
                request: RemoveFromGlobalClusterRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.RemoveFromGlobalClusterResponse.ReadOnly
            ] = proxy(RemoveFromGlobalCluster, request)
            def modifyDBClusterParameterGroup(
                request: ModifyDbClusterParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse.ReadOnly
            ] = proxy(ModifyDBClusterParameterGroup, request)
            def stopDBCluster(request: StopDbClusterRequest): IO[
              AwsError,
              zio.aws.neptune.model.StopDbClusterResponse.ReadOnly
            ] = proxy(StopDBCluster, request)
            def createDBCluster(request: CreateDbClusterRequest): IO[
              AwsError,
              zio.aws.neptune.model.CreateDbClusterResponse.ReadOnly
            ] = proxy(CreateDBCluster, request)
            def deleteEventSubscription(
                request: DeleteEventSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DeleteEventSubscriptionResponse.ReadOnly
            ] = proxy(DeleteEventSubscription, request)
            def deleteDBParameterGroup(
                request: DeleteDbParameterGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteDBParameterGroup, request)
            def describeDBSubnetGroups(
                request: DescribeDbSubnetGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.DBSubnetGroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBSubnetGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBSubnetGroupsPaginated(
                request: DescribeDbSubnetGroupsRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.ReadOnly
            ] = proxy(DescribeDBSubnetGroupsPaginated, request)
            def removeRoleFromDBCluster(
                request: RemoveRoleFromDbClusterRequest
            ): IO[AwsError, Unit] = proxy(RemoveRoleFromDBCluster, request)
            def createDBClusterParameterGroup(
                request: CreateDbClusterParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.CreateDbClusterParameterGroupResponse.ReadOnly
            ] = proxy(CreateDBClusterParameterGroup, request)
            def modifyDBCluster(request: ModifyDbClusterRequest): IO[
              AwsError,
              zio.aws.neptune.model.ModifyDbClusterResponse.ReadOnly
            ] = proxy(ModifyDBCluster, request)
            def describeValidDBInstanceModifications(
                request: DescribeValidDbInstanceModificationsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(DescribeValidDBInstanceModifications, request)
            def resetDBParameterGroup(
                request: ResetDbParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.ResetDbParameterGroupResponse.ReadOnly
            ] = proxy(ResetDBParameterGroup, request)
            def removeTagsFromResource(
                request: RemoveTagsFromResourceRequest
            ): IO[AwsError, Unit] = proxy(RemoveTagsFromResource, request)
            def createDBParameterGroup(
                request: CreateDbParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.CreateDbParameterGroupResponse.ReadOnly
            ] = proxy(CreateDBParameterGroup, request)
            def applyPendingMaintenanceAction(
                request: ApplyPendingMaintenanceActionRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.ApplyPendingMaintenanceActionResponse.ReadOnly
            ] = proxy(ApplyPendingMaintenanceAction, request)
            def modifyDBSubnetGroup(request: ModifyDbSubnetGroupRequest): IO[
              AwsError,
              zio.aws.neptune.model.ModifyDbSubnetGroupResponse.ReadOnly
            ] = proxy(ModifyDBSubnetGroup, request)
            def modifyGlobalCluster(request: ModifyGlobalClusterRequest): IO[
              AwsError,
              zio.aws.neptune.model.ModifyGlobalClusterResponse.ReadOnly
            ] = proxy(ModifyGlobalCluster, request)
            def restoreDBClusterFromSnapshot(
                request: RestoreDbClusterFromSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
            ] = proxy(RestoreDBClusterFromSnapshot, request)
            def describeGlobalClusters(
                request: DescribeGlobalClustersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.GlobalCluster.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeGlobalClusters, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeGlobalClustersPaginated(
                request: DescribeGlobalClustersRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeGlobalClustersResponse.ReadOnly
            ] = proxy(DescribeGlobalClustersPaginated, request)
            def describeDBClusterParameters(
                request: DescribeDbClusterParametersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.Parameter.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBClusterParameters, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBClusterParametersPaginated(
                request: DescribeDbClusterParametersRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbClusterParametersResponse.ReadOnly
            ] = proxy(DescribeDBClusterParametersPaginated, request)
            def copyDBParameterGroup(request: CopyDbParameterGroupRequest): IO[
              AwsError,
              zio.aws.neptune.model.CopyDbParameterGroupResponse.ReadOnly
            ] = proxy(CopyDBParameterGroup, request)
            def modifyEventSubscription(
                request: ModifyEventSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.ModifyEventSubscriptionResponse.ReadOnly
            ] = proxy(ModifyEventSubscription, request)
            def modifyDBParameterGroup(
                request: ModifyDbParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.ModifyDbParameterGroupResponse.ReadOnly
            ] = proxy(ModifyDBParameterGroup, request)
            def createDBInstance(request: CreateDbInstanceRequest): IO[
              AwsError,
              zio.aws.neptune.model.CreateDbInstanceResponse.ReadOnly
            ] = proxy(CreateDBInstance, request)
            def deleteDBClusterSnapshot(
                request: DeleteDbClusterSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DeleteDbClusterSnapshotResponse.ReadOnly
            ] = proxy(DeleteDBClusterSnapshot, request)
            def startDBCluster(request: StartDbClusterRequest): IO[
              AwsError,
              zio.aws.neptune.model.StartDbClusterResponse.ReadOnly
            ] = proxy(StartDBCluster, request)
            def modifyDBClusterSnapshotAttribute(
                request: ModifyDbClusterSnapshotAttributeRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
            ] = proxy(ModifyDBClusterSnapshotAttribute, request)
            def describeEventCategories(
                request: DescribeEventCategoriesRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeEventCategoriesResponse.ReadOnly
            ] = proxy(DescribeEventCategories, request)
            def deleteDBSubnetGroup(
                request: DeleteDbSubnetGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteDBSubnetGroup, request)
            def modifyDBClusterEndpoint(
                request: ModifyDbClusterEndpointRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.ModifyDbClusterEndpointResponse.ReadOnly
            ] = proxy(ModifyDBClusterEndpoint, request)
            def promoteReadReplicaDBCluster(
                request: PromoteReadReplicaDbClusterRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse.ReadOnly
            ] = proxy(PromoteReadReplicaDBCluster, request)
            def rebootDBInstance(request: RebootDbInstanceRequest): IO[
              AwsError,
              zio.aws.neptune.model.RebootDbInstanceResponse.ReadOnly
            ] = proxy(RebootDBInstance, request)
            def describeDBClusterParameterGroups(
                request: DescribeDbClusterParameterGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBClusterParameterGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBClusterParameterGroupsPaginated(
                request: DescribeDbClusterParameterGroupsRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
            ] = proxy(DescribeDBClusterParameterGroupsPaginated, request)
            def createEventSubscription(
                request: CreateEventSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.CreateEventSubscriptionResponse.ReadOnly
            ] = proxy(CreateEventSubscription, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.neptune.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def restoreDBClusterToPointInTime(
                request: RestoreDbClusterToPointInTimeRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
            ] = proxy(RestoreDBClusterToPointInTime, request)
            def describeDBClusters(request: DescribeDbClustersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.DBCluster.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBClusters, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBClustersPaginated(
                request: DescribeDbClustersRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbClustersResponse.ReadOnly
            ] = proxy(DescribeDBClustersPaginated, request)
            def failoverDBCluster(request: FailoverDbClusterRequest): IO[
              AwsError,
              zio.aws.neptune.model.FailoverDbClusterResponse.ReadOnly
            ] = proxy(FailoverDBCluster, request)
            def describeEventSubscriptions(
                request: DescribeEventSubscriptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.EventSubscription.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeEventSubscriptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeEventSubscriptionsPaginated(
                request: DescribeEventSubscriptionsRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeEventSubscriptionsResponse.ReadOnly
            ] = proxy(DescribeEventSubscriptionsPaginated, request)
            def describeDBInstances(
                request: DescribeDbInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.DBInstance.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBInstances, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBInstancesPaginated(
                request: DescribeDbInstancesRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbInstancesResponse.ReadOnly
            ] = proxy(DescribeDBInstancesPaginated, request)
            def createDBClusterSnapshot(
                request: CreateDbClusterSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.CreateDbClusterSnapshotResponse.ReadOnly
            ] = proxy(CreateDBClusterSnapshot, request)
            def deleteDBCluster(request: DeleteDbClusterRequest): IO[
              AwsError,
              zio.aws.neptune.model.DeleteDbClusterResponse.ReadOnly
            ] = proxy(DeleteDBCluster, request)
            def deleteGlobalCluster(request: DeleteGlobalClusterRequest): IO[
              AwsError,
              zio.aws.neptune.model.DeleteGlobalClusterResponse.ReadOnly
            ] = proxy(DeleteGlobalCluster, request)
            def deleteDBInstance(request: DeleteDbInstanceRequest): IO[
              AwsError,
              zio.aws.neptune.model.DeleteDbInstanceResponse.ReadOnly
            ] = proxy(DeleteDBInstance, request)
            def addSourceIdentifierToSubscription(
                request: AddSourceIdentifierToSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
            ] = proxy(AddSourceIdentifierToSubscription, request)
            def describeDBEngineVersions(
                request: DescribeDbEngineVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.DBEngineVersion.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBEngineVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBEngineVersionsPaginated(
                request: DescribeDbEngineVersionsRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbEngineVersionsResponse.ReadOnly
            ] = proxy(DescribeDBEngineVersionsPaginated, request)
            def createGlobalCluster(request: CreateGlobalClusterRequest): IO[
              AwsError,
              zio.aws.neptune.model.CreateGlobalClusterResponse.ReadOnly
            ] = proxy(CreateGlobalCluster, request)
            def describeOrderableDBInstanceOptions(
                request: DescribeOrderableDbInstanceOptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeOrderableDBInstanceOptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeOrderableDBInstanceOptionsPaginated(
                request: DescribeOrderableDbInstanceOptionsRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
            ] = proxy(DescribeOrderableDBInstanceOptionsPaginated, request)
            def describeDBClusterSnapshotAttributes(
                request: DescribeDbClusterSnapshotAttributesRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
            ] = proxy(DescribeDBClusterSnapshotAttributes, request)
            def describeEvents(
                request: DescribeEventsRequest
            ): ZStream[Any, AwsError, zio.aws.neptune.model.Event.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeEvents, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeEventsPaginated(request: DescribeEventsRequest): IO[
              AwsError,
              zio.aws.neptune.model.DescribeEventsResponse.ReadOnly
            ] = proxy(DescribeEventsPaginated, request)
            def describeDBParameterGroups(
                request: DescribeDbParameterGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.neptune.model.DBParameterGroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBParameterGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBParameterGroupsPaginated(
                request: DescribeDbParameterGroupsRequest
            ): IO[
              AwsError,
              zio.aws.neptune.model.DescribeDbParameterGroupsResponse.ReadOnly
            ] = proxy(DescribeDBParameterGroupsPaginated, request)
          }
        }
      }
    }
  }
}
