package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbClusterResponse(
    dbCluster: Optional[zio.aws.neptune.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse = {
    import CreateDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.CreateDbClusterResponse.ReadOnly =
    zio.aws.neptune.model.CreateDbClusterResponse.wrap(buildAwsValue())
}
object CreateDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CreateDbClusterResponse =
      zio.aws.neptune.model
        .CreateDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse
  ) extends zio.aws.neptune.model.CreateDbClusterResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.neptune.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse
  ): zio.aws.neptune.model.CreateDbClusterResponse.ReadOnly = new Wrapper(impl)
}
