package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbClusterSnapshotRequest(
    dbClusterSnapshotIdentifier: String,
    dbClusterIdentifier: String,
    tags: Optional[Iterable[zio.aws.neptune.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest = {
    import CreateDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest
      .builder()
      .dbClusterSnapshotIdentifier(
        dbClusterSnapshotIdentifier: java.lang.String
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.CreateDbClusterSnapshotRequest.ReadOnly =
    zio.aws.neptune.model.CreateDbClusterSnapshotRequest.wrap(buildAwsValue())
}
object CreateDbClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CreateDbClusterSnapshotRequest =
      zio.aws.neptune.model.CreateDbClusterSnapshotRequest(
        dbClusterSnapshotIdentifier,
        dbClusterIdentifier,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbClusterSnapshotIdentifier: String
    def dbClusterIdentifier: String
    def tags: Optional[List[zio.aws.neptune.model.Tag.ReadOnly]]
    def getDbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterSnapshotIdentifier)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getTags: ZIO[Any, AwsError, List[zio.aws.neptune.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest
  ) extends zio.aws.neptune.model.CreateDbClusterSnapshotRequest.ReadOnly {
    override val dbClusterSnapshotIdentifier: String =
      impl.dbClusterSnapshotIdentifier(): String
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val tags: Optional[List[zio.aws.neptune.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest
  ): zio.aws.neptune.model.CreateDbClusterSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
