package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbParameterGroupRequest(
    dbParameterGroupName: String,
    dbParameterGroupFamily: String,
    description: String,
    tags: Optional[Iterable[zio.aws.neptune.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest = {
    import CreateDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest
      .builder()
      .dbParameterGroupName(dbParameterGroupName: java.lang.String)
      .dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.CreateDbParameterGroupRequest.ReadOnly =
    zio.aws.neptune.model.CreateDbParameterGroupRequest.wrap(buildAwsValue())
}
object CreateDbParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CreateDbParameterGroupRequest =
      zio.aws.neptune.model.CreateDbParameterGroupRequest(
        dbParameterGroupName,
        dbParameterGroupFamily,
        description,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbParameterGroupName: String
    def dbParameterGroupFamily: String
    def description: String
    def tags: Optional[List[zio.aws.neptune.model.Tag.ReadOnly]]
    def getDbParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbParameterGroupName)
    def getDbParameterGroupFamily: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbParameterGroupFamily)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.neptune.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest
  ) extends zio.aws.neptune.model.CreateDbParameterGroupRequest.ReadOnly {
    override val dbParameterGroupName: String =
      impl.dbParameterGroupName(): String
    override val dbParameterGroupFamily: String =
      impl.dbParameterGroupFamily(): String
    override val description: String = impl.description(): String
    override val tags: Optional[List[zio.aws.neptune.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest
  ): zio.aws.neptune.model.CreateDbParameterGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
