package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbSubnetGroupResponse(
    dbSubnetGroup: Optional[zio.aws.neptune.model.DBSubnetGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse = {
    import CreateDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse
      .builder()
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.CreateDbSubnetGroupResponse.ReadOnly =
    zio.aws.neptune.model.CreateDbSubnetGroupResponse.wrap(buildAwsValue())
}
object CreateDbSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CreateDbSubnetGroupResponse =
      zio.aws.neptune.model.CreateDbSubnetGroupResponse(
        dbSubnetGroup.map(value => value.asEditable)
      )
    def dbSubnetGroup: Optional[zio.aws.neptune.model.DBSubnetGroup.ReadOnly]
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse
  ) extends zio.aws.neptune.model.CreateDbSubnetGroupResponse.ReadOnly {
    override val dbSubnetGroup
        : Optional[zio.aws.neptune.model.DBSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroup())
        .map(value => zio.aws.neptune.model.DBSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse
  ): zio.aws.neptune.model.CreateDbSubnetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
