package zio.aws.neptune.model
import zio.aws.neptune.model.primitives.{
  BooleanOptional,
  TStamp,
  IntegerOptional
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DBCluster(
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    characterSetName: Optional[String] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    dbClusterParameterGroup: Optional[String] = Optional.Absent,
    dbSubnetGroup: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    percentProgress: Optional[String] = Optional.Absent,
    earliestRestorableTime: Optional[TStamp] = Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    readerEndpoint: Optional[String] = Optional.Absent,
    multiAZ: Optional[Boolean] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    latestRestorableTime: Optional[TStamp] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    dbClusterOptionGroupMemberships: Optional[
      Iterable[zio.aws.neptune.model.DBClusterOptionGroupStatus]
    ] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    replicationSourceIdentifier: Optional[String] = Optional.Absent,
    readReplicaIdentifiers: Optional[Iterable[String]] = Optional.Absent,
    dbClusterMembers: Optional[
      Iterable[zio.aws.neptune.model.DBClusterMember]
    ] = Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.neptune.model.VpcSecurityGroupMembership]
    ] = Optional.Absent,
    hostedZoneId: Optional[String] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    dbClusterResourceId: Optional[String] = Optional.Absent,
    dbClusterArn: Optional[String] = Optional.Absent,
    associatedRoles: Optional[Iterable[zio.aws.neptune.model.DBClusterRole]] =
      Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent,
    cloneGroupId: Optional[String] = Optional.Absent,
    clusterCreateTime: Optional[TStamp] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    enabledCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    crossAccountClone: Optional[BooleanOptional] = Optional.Absent,
    automaticRestartTime: Optional[TStamp] = Optional.Absent,
    serverlessV2ScalingConfiguration: Optional[
      zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DBCluster = {
    import DBCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DBCluster
      .builder()
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterParameterGroup.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroup)
      .optionallyWith(dbSubnetGroup.map(value => value: java.lang.String))(
        _.dbSubnetGroup
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(percentProgress.map(value => value: java.lang.String))(
        _.percentProgress
      )
      .optionallyWith(
        earliestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.earliestRestorableTime)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(readerEndpoint.map(value => value: java.lang.String))(
        _.readerEndpoint
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        latestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(
        dbClusterOptionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterOptionGroupMemberships)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        replicationSourceIdentifier.map(value => value: java.lang.String)
      )(_.replicationSourceIdentifier)
      .optionallyWith(
        readReplicaIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaIdentifiers)
      .optionallyWith(
        dbClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterMembers)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        dbClusterResourceId.map(value => value: java.lang.String)
      )(_.dbClusterResourceId)
      .optionallyWith(dbClusterArn.map(value => value: java.lang.String))(
        _.dbClusterArn
      )
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(cloneGroupId.map(value => value: java.lang.String))(
        _.cloneGroupId
      )
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        enabledCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudwatchLogsExports)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(crossAccountClone.map(value => value: java.lang.Boolean))(
        _.crossAccountClone
      )
      .optionallyWith(
        automaticRestartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.automaticRestartTime)
      .optionallyWith(
        serverlessV2ScalingConfiguration.map(value => value.buildAwsValue())
      )(_.serverlessV2ScalingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DBCluster.ReadOnly =
    zio.aws.neptune.model.DBCluster.wrap(buildAwsValue())
}
object DBCluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.neptune.model.DBCluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DBCluster =
      zio.aws.neptune.model.DBCluster(
        allocatedStorage.map(value => value),
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        characterSetName.map(value => value),
        databaseName.map(value => value),
        dbClusterIdentifier.map(value => value),
        dbClusterParameterGroup.map(value => value),
        dbSubnetGroup.map(value => value),
        status.map(value => value),
        percentProgress.map(value => value),
        earliestRestorableTime.map(value => value),
        endpoint.map(value => value),
        readerEndpoint.map(value => value),
        multiAZ.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        latestRestorableTime.map(value => value),
        port.map(value => value),
        masterUsername.map(value => value),
        dbClusterOptionGroupMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        replicationSourceIdentifier.map(value => value),
        readReplicaIdentifiers.map(value => value),
        dbClusterMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostedZoneId.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbClusterResourceId.map(value => value),
        dbClusterArn.map(value => value),
        associatedRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        iamDatabaseAuthenticationEnabled.map(value => value),
        cloneGroupId.map(value => value),
        clusterCreateTime.map(value => value),
        copyTagsToSnapshot.map(value => value),
        enabledCloudwatchLogsExports.map(value => value),
        deletionProtection.map(value => value),
        crossAccountClone.map(value => value),
        automaticRestartTime.map(value => value),
        serverlessV2ScalingConfiguration.map(value => value.asEditable)
      )
    def allocatedStorage: Optional[IntegerOptional]
    def availabilityZones: Optional[List[String]]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def characterSetName: Optional[String]
    def databaseName: Optional[String]
    def dbClusterIdentifier: Optional[String]
    def dbClusterParameterGroup: Optional[String]
    def dbSubnetGroup: Optional[String]
    def status: Optional[String]
    def percentProgress: Optional[String]
    def earliestRestorableTime: Optional[TStamp]
    def endpoint: Optional[String]
    def readerEndpoint: Optional[String]
    def multiAZ: Optional[Boolean]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def latestRestorableTime: Optional[TStamp]
    def port: Optional[IntegerOptional]
    def masterUsername: Optional[String]
    def dbClusterOptionGroupMemberships: Optional[
      List[zio.aws.neptune.model.DBClusterOptionGroupStatus.ReadOnly]
    ]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def replicationSourceIdentifier: Optional[String]
    def readReplicaIdentifiers: Optional[List[String]]
    def dbClusterMembers
        : Optional[List[zio.aws.neptune.model.DBClusterMember.ReadOnly]]
    def vpcSecurityGroups: Optional[
      List[zio.aws.neptune.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def hostedZoneId: Optional[String]
    def storageEncrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def dbClusterResourceId: Optional[String]
    def dbClusterArn: Optional[String]
    def associatedRoles
        : Optional[List[zio.aws.neptune.model.DBClusterRole.ReadOnly]]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def cloneGroupId: Optional[String]
    def clusterCreateTime: Optional[TStamp]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def enabledCloudwatchLogsExports: Optional[List[String]]
    def deletionProtection: Optional[BooleanOptional]
    def crossAccountClone: Optional[BooleanOptional]
    def automaticRestartTime: Optional[TStamp]
    def serverlessV2ScalingConfiguration: Optional[
      zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo.ReadOnly
    ]
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterParameterGroup: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterParameterGroup", dbClusterParameterGroup)
    def getDbSubnetGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPercentProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getEarliestRestorableTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("earliestRestorableTime", earliestRestorableTime)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getReaderEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("readerEndpoint", readerEndpoint)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLatestRestorableTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getDbClusterOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DBClusterOptionGroupStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterOptionGroupMemberships",
      dbClusterOptionGroupMemberships
    )
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getReplicationSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSourceIdentifier",
        replicationSourceIdentifier
      )
    def getReadReplicaIdentifiers: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("readReplicaIdentifiers", readReplicaIdentifiers)
    def getDbClusterMembers: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DBClusterMember.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterMembers", dbClusterMembers)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterResourceId", dbClusterResourceId)
    def getDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterArn", dbClusterArn)
    def getAssociatedRoles: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DBClusterRole.ReadOnly
    ]] = AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getCloneGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloneGroupId", cloneGroupId)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getEnabledCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enabledCloudwatchLogsExports",
        enabledCloudwatchLogsExports
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getCrossAccountClone: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("crossAccountClone", crossAccountClone)
    def getAutomaticRestartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("automaticRestartTime", automaticRestartTime)
    def getServerlessV2ScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverlessV2ScalingConfiguration",
      serverlessV2ScalingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DBCluster
  ) extends zio.aws.neptune.model.DBCluster.ReadOnly {
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val characterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.characterSetName())
      .map(value => value: String)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val dbClusterParameterGroup: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroup())
        .map(value => value: String)
    override val dbSubnetGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroup())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val percentProgress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.percentProgress())
      .map(value => value: String)
    override val earliestRestorableTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.earliestRestorableTime())
        .map(value => zio.aws.neptune.model.primitives.TStamp(value))
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val readerEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.readerEndpoint())
      .map(value => value: String)
    override val multiAZ: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: Boolean)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val latestRestorableTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRestorableTime())
      .map(value => zio.aws.neptune.model.primitives.TStamp(value))
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val dbClusterOptionGroupMemberships: Optional[
      List[zio.aws.neptune.model.DBClusterOptionGroupStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterOptionGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.neptune.model.DBClusterOptionGroupStatus.wrap(item)
        }.toList
      )
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val replicationSourceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSourceIdentifier())
        .map(value => value: String)
    override val readReplicaIdentifiers: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readReplicaIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dbClusterMembers
        : Optional[List[zio.aws.neptune.model.DBClusterMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterMembers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.DBClusterMember.wrap(item)
          }.toList
        )
    override val vpcSecurityGroups: Optional[
      List[zio.aws.neptune.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.neptune.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val hostedZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => value: String)
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val dbClusterResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterResourceId())
      .map(value => value: String)
    override val dbClusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterArn())
      .map(value => value: String)
    override val associatedRoles
        : Optional[List[zio.aws.neptune.model.DBClusterRole.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedRoles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.DBClusterRole.wrap(item)
          }.toList
        )
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
    override val cloneGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cloneGroupId())
      .map(value => value: String)
    override val clusterCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterCreateTime())
      .map(value => zio.aws.neptune.model.primitives.TStamp(value))
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val enabledCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val crossAccountClone: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossAccountClone())
        .map(value => value: BooleanOptional)
    override val automaticRestartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticRestartTime())
      .map(value => zio.aws.neptune.model.primitives.TStamp(value))
    override val serverlessV2ScalingConfiguration: Optional[
      zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverlessV2ScalingConfiguration())
      .map(value =>
        zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DBCluster
  ): zio.aws.neptune.model.DBCluster.ReadOnly = new Wrapper(impl)
}
