package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBClusterRole(
    roleArn: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    featureName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DBClusterRole = {
    import DBClusterRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DBClusterRole
      .builder()
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(featureName.map(value => value: java.lang.String))(
        _.featureName
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DBClusterRole.ReadOnly =
    zio.aws.neptune.model.DBClusterRole.wrap(buildAwsValue())
}
object DBClusterRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DBClusterRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DBClusterRole =
      zio.aws.neptune.model.DBClusterRole(
        roleArn.map(value => value),
        status.map(value => value),
        featureName.map(value => value)
      )
    def roleArn: Optional[String]
    def status: Optional[String]
    def featureName: Optional[String]
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getFeatureName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featureName", featureName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DBClusterRole
  ) extends zio.aws.neptune.model.DBClusterRole.ReadOnly {
    override val roleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val featureName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.featureName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DBClusterRole
  ): zio.aws.neptune.model.DBClusterRole.ReadOnly = new Wrapper(impl)
}
