package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbClusterParameterGroupRequest(
    dbClusterParameterGroupName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest = {
    import DeleteDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest
      .builder()
      .dbClusterParameterGroupName(
        dbClusterParameterGroupName: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DeleteDbClusterParameterGroupRequest.ReadOnly =
    zio.aws.neptune.model.DeleteDbClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object DeleteDbClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DeleteDbClusterParameterGroupRequest =
      zio.aws.neptune.model
        .DeleteDbClusterParameterGroupRequest(dbClusterParameterGroupName)
    def dbClusterParameterGroupName: String
    def getDbClusterParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterParameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest
  ) extends zio.aws.neptune.model.DeleteDbClusterParameterGroupRequest.ReadOnly {
    override val dbClusterParameterGroupName: String =
      impl.dbClusterParameterGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest
  ): zio.aws.neptune.model.DeleteDbClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
