package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDbClusterRequest(
    dbClusterIdentifier: String,
    skipFinalSnapshot: Optional[Boolean] = Optional.Absent,
    finalDBSnapshotIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest = {
    import DeleteDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(
        _.skipFinalSnapshot
      )
      .optionallyWith(
        finalDBSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.finalDBSnapshotIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DeleteDbClusterRequest.ReadOnly =
    zio.aws.neptune.model.DeleteDbClusterRequest.wrap(buildAwsValue())
}
object DeleteDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DeleteDbClusterRequest =
      zio.aws.neptune.model.DeleteDbClusterRequest(
        dbClusterIdentifier,
        skipFinalSnapshot.map(value => value),
        finalDBSnapshotIdentifier.map(value => value)
      )
    def dbClusterIdentifier: String
    def skipFinalSnapshot: Optional[Boolean]
    def finalDBSnapshotIdentifier: Optional[String]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getSkipFinalSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshot)
    def getFinalDBSnapshotIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("finalDBSnapshotIdentifier", finalDBSnapshotIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest
  ) extends zio.aws.neptune.model.DeleteDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val skipFinalSnapshot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.skipFinalSnapshot())
      .map(value => value: Boolean)
    override val finalDBSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalDBSnapshotIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest
  ): zio.aws.neptune.model.DeleteDbClusterRequest.ReadOnly = new Wrapper(impl)
}
