package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDbInstanceResponse(
    dbInstance: Optional[zio.aws.neptune.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse = {
    import DeleteDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DeleteDbInstanceResponse.ReadOnly =
    zio.aws.neptune.model.DeleteDbInstanceResponse.wrap(buildAwsValue())
}
object DeleteDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DeleteDbInstanceResponse =
      zio.aws.neptune.model
        .DeleteDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: Optional[zio.aws.neptune.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse
  ) extends zio.aws.neptune.model.DeleteDbInstanceResponse.ReadOnly {
    override val dbInstance
        : Optional[zio.aws.neptune.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.neptune.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse
  ): zio.aws.neptune.model.DeleteDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
