package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbParameterGroupRequest(dbParameterGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest = {
    import DeleteDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest
      .builder()
      .dbParameterGroupName(dbParameterGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DeleteDbParameterGroupRequest.ReadOnly =
    zio.aws.neptune.model.DeleteDbParameterGroupRequest.wrap(buildAwsValue())
}
object DeleteDbParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DeleteDbParameterGroupRequest =
      zio.aws.neptune.model.DeleteDbParameterGroupRequest(dbParameterGroupName)
    def dbParameterGroupName: String
    def getDbParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbParameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest
  ) extends zio.aws.neptune.model.DeleteDbParameterGroupRequest.ReadOnly {
    override val dbParameterGroupName: String =
      impl.dbParameterGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest
  ): zio.aws.neptune.model.DeleteDbParameterGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
