package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteGlobalClusterResponse(
    globalCluster: Optional[zio.aws.neptune.model.GlobalCluster] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterResponse = {
    import DeleteGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DeleteGlobalClusterResponse.ReadOnly =
    zio.aws.neptune.model.DeleteGlobalClusterResponse.wrap(buildAwsValue())
}
object DeleteGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DeleteGlobalClusterResponse =
      zio.aws.neptune.model.DeleteGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterResponse
  ) extends zio.aws.neptune.model.DeleteGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalCluster())
        .map(value => zio.aws.neptune.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterResponse
  ): zio.aws.neptune.model.DeleteGlobalClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
