package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterEndpointsResponse(
    marker: Optional[String] = Optional.Absent,
    dbClusterEndpoints: Optional[
      Iterable[zio.aws.neptune.model.DBClusterEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse = {
    import DescribeDbClusterEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterEndpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeDbClusterEndpointsResponse.ReadOnly =
    zio.aws.neptune.model.DescribeDbClusterEndpointsResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DescribeDbClusterEndpointsResponse =
      zio.aws.neptune.model.DescribeDbClusterEndpointsResponse(
        marker.map(value => value),
        dbClusterEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbClusterEndpoints
        : Optional[List[zio.aws.neptune.model.DBClusterEndpoint.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterEndpoints: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DBClusterEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterEndpoints", dbClusterEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse
  ) extends zio.aws.neptune.model.DescribeDbClusterEndpointsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbClusterEndpoints
        : Optional[List[zio.aws.neptune.model.DBClusterEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.DBClusterEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse
  ): zio.aws.neptune.model.DescribeDbClusterEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
