package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEngineDefaultClusterParametersResponse(
    engineDefaults: Optional[zio.aws.neptune.model.EngineDefaults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse = {
    import DescribeEngineDefaultClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse
      .builder()
      .optionallyWith(engineDefaults.map(value => value.buildAwsValue()))(
        _.engineDefaults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly =
    zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse
      .wrap(buildAwsValue())
}
object DescribeEngineDefaultClusterParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse =
      zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse(
        engineDefaults.map(value => value.asEditable)
      )
    def engineDefaults: Optional[zio.aws.neptune.model.EngineDefaults.ReadOnly]
    def getEngineDefaults
        : ZIO[Any, AwsError, zio.aws.neptune.model.EngineDefaults.ReadOnly] =
      AwsError.unwrapOptionField("engineDefaults", engineDefaults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse
  ) extends zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly {
    override val engineDefaults
        : Optional[zio.aws.neptune.model.EngineDefaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineDefaults())
        .map(value => zio.aws.neptune.model.EngineDefaults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse
  ): zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly =
    new Wrapper(impl)
}
