package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventSubscriptionsResponse(
    marker: Optional[String] = Optional.Absent,
    eventSubscriptionsList: Optional[
      Iterable[zio.aws.neptune.model.EventSubscription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse = {
    import DescribeEventSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        eventSubscriptionsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventSubscriptionsList)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeEventSubscriptionsResponse.ReadOnly =
    zio.aws.neptune.model.DescribeEventSubscriptionsResponse
      .wrap(buildAwsValue())
}
object DescribeEventSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DescribeEventSubscriptionsResponse =
      zio.aws.neptune.model.DescribeEventSubscriptionsResponse(
        marker.map(value => value),
        eventSubscriptionsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def eventSubscriptionsList
        : Optional[List[zio.aws.neptune.model.EventSubscription.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getEventSubscriptionsList: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.EventSubscription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventSubscriptionsList",
      eventSubscriptionsList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse
  ) extends zio.aws.neptune.model.DescribeEventSubscriptionsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val eventSubscriptionsList
        : Optional[List[zio.aws.neptune.model.EventSubscription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSubscriptionsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.EventSubscription.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse
  ): zio.aws.neptune.model.DescribeEventSubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
