package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeValidDbInstanceModificationsResponse(
    validDBInstanceModificationsMessage: Optional[
      zio.aws.neptune.model.ValidDBInstanceModificationsMessage
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse = {
    import DescribeValidDbInstanceModificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse
      .builder()
      .optionallyWith(
        validDBInstanceModificationsMessage.map(value => value.buildAwsValue())
      )(_.validDBInstanceModificationsMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeValidDbInstanceModificationsResponse.ReadOnly =
    zio.aws.neptune.model.DescribeValidDbInstanceModificationsResponse
      .wrap(buildAwsValue())
}
object DescribeValidDbInstanceModificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.DescribeValidDbInstanceModificationsResponse =
      zio.aws.neptune.model.DescribeValidDbInstanceModificationsResponse(
        validDBInstanceModificationsMessage.map(value => value.asEditable)
      )
    def validDBInstanceModificationsMessage: Optional[
      zio.aws.neptune.model.ValidDBInstanceModificationsMessage.ReadOnly
    ]
    def getValidDBInstanceModificationsMessage: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.ValidDBInstanceModificationsMessage.ReadOnly
    ] = AwsError.unwrapOptionField(
      "validDBInstanceModificationsMessage",
      validDBInstanceModificationsMessage
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse
  ) extends zio.aws.neptune.model.DescribeValidDbInstanceModificationsResponse.ReadOnly {
    override val validDBInstanceModificationsMessage: Optional[
      zio.aws.neptune.model.ValidDBInstanceModificationsMessage.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validDBInstanceModificationsMessage())
      .map(value =>
        zio.aws.neptune.model.ValidDBInstanceModificationsMessage.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse
  ): zio.aws.neptune.model.DescribeValidDbInstanceModificationsResponse.ReadOnly =
    new Wrapper(impl)
}
