package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FailoverDbClusterRequest(
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    targetDBInstanceIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest = {
    import FailoverDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest
      .builder()
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        targetDBInstanceIdentifier.map(value => value: java.lang.String)
      )(_.targetDBInstanceIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.FailoverDbClusterRequest.ReadOnly =
    zio.aws.neptune.model.FailoverDbClusterRequest.wrap(buildAwsValue())
}
object FailoverDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.FailoverDbClusterRequest =
      zio.aws.neptune.model.FailoverDbClusterRequest(
        dbClusterIdentifier.map(value => value),
        targetDBInstanceIdentifier.map(value => value)
      )
    def dbClusterIdentifier: Optional[String]
    def targetDBInstanceIdentifier: Optional[String]
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getTargetDBInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "targetDBInstanceIdentifier",
        targetDBInstanceIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest
  ) extends zio.aws.neptune.model.FailoverDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val targetDBInstanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetDBInstanceIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest
  ): zio.aws.neptune.model.FailoverDbClusterRequest.ReadOnly = new Wrapper(impl)
}
