package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.neptune.model.primitives.GlobalClusterIdentifier
import scala.jdk.CollectionConverters._
final case class FailoverGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier,
    targetDbClusterIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterRequest = {
    import FailoverGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .targetDbClusterIdentifier(targetDbClusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.FailoverGlobalClusterRequest.ReadOnly =
    zio.aws.neptune.model.FailoverGlobalClusterRequest.wrap(buildAwsValue())
}
object FailoverGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.FailoverGlobalClusterRequest =
      zio.aws.neptune.model.FailoverGlobalClusterRequest(
        globalClusterIdentifier,
        targetDbClusterIdentifier
      )
    def globalClusterIdentifier: GlobalClusterIdentifier
    def targetDbClusterIdentifier: String
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
    def getTargetDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterRequest
  ) extends zio.aws.neptune.model.FailoverGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.neptune.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
    override val targetDbClusterIdentifier: String =
      impl.targetDbClusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterRequest
  ): zio.aws.neptune.model.FailoverGlobalClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
