package zio.aws.neptune.model
import zio.aws.neptune.model.primitives.{BooleanOptional, IntegerOptional}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterRequest(
    dbClusterIdentifier: String,
    newDBClusterIdentifier: Optional[String] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    masterUserPassword: Optional[String] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    cloudwatchLogsExportConfiguration: Optional[
      zio.aws.neptune.model.CloudwatchLogsExportConfiguration
    ] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    allowMajorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    dbInstanceParameterGroupName: Optional[String] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    serverlessV2ScalingConfiguration: Optional[
      zio.aws.neptune.model.ServerlessV2ScalingConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest = {
    import ModifyDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .optionallyWith(
        newDBClusterIdentifier.map(value => value: java.lang.String)
      )(_.newDBClusterIdentifier)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue())
      )(_.cloudwatchLogsExportConfiguration)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpgrade)
      .optionallyWith(
        dbInstanceParameterGroupName.map(value => value: java.lang.String)
      )(_.dbInstanceParameterGroupName)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        serverlessV2ScalingConfiguration.map(value => value.buildAwsValue())
      )(_.serverlessV2ScalingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ModifyDbClusterRequest.ReadOnly =
    zio.aws.neptune.model.ModifyDbClusterRequest.wrap(buildAwsValue())
}
object ModifyDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyDbClusterRequest =
      zio.aws.neptune.model.ModifyDbClusterRequest(
        dbClusterIdentifier,
        newDBClusterIdentifier.map(value => value),
        applyImmediately.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbClusterParameterGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        port.map(value => value),
        masterUserPassword.map(value => value),
        optionGroupName.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        cloudwatchLogsExportConfiguration.map(value => value.asEditable),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value),
        dbInstanceParameterGroupName.map(value => value),
        deletionProtection.map(value => value),
        copyTagsToSnapshot.map(value => value),
        serverlessV2ScalingConfiguration.map(value => value.asEditable)
      )
    def dbClusterIdentifier: String
    def newDBClusterIdentifier: Optional[String]
    def applyImmediately: Optional[Boolean]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def dbClusterParameterGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def port: Optional[IntegerOptional]
    def masterUserPassword: Optional[String]
    def optionGroupName: Optional[String]
    def preferredBackupWindow: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def cloudwatchLogsExportConfiguration: Optional[
      zio.aws.neptune.model.CloudwatchLogsExportConfiguration.ReadOnly
    ]
    def engineVersion: Optional[String]
    def allowMajorVersionUpgrade: Optional[Boolean]
    def dbInstanceParameterGroupName: Optional[String]
    def deletionProtection: Optional[BooleanOptional]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def serverlessV2ScalingConfiguration: Optional[
      zio.aws.neptune.model.ServerlessV2ScalingConfiguration.ReadOnly
    ]
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
    def getNewDBClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("newDBClusterIdentifier", newDBClusterIdentifier)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getCloudwatchLogsExportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudwatchLogsExportConfiguration",
      cloudwatchLogsExportConfiguration
    )
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgrade)
    def getDbInstanceParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbInstanceParameterGroupName",
        dbInstanceParameterGroupName
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getServerlessV2ScalingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.ServerlessV2ScalingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverlessV2ScalingConfiguration",
      serverlessV2ScalingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest
  ) extends zio.aws.neptune.model.ModifyDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
    override val newDBClusterIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newDBClusterIdentifier())
        .map(value => value: String)
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val cloudwatchLogsExportConfiguration: Optional[
      zio.aws.neptune.model.CloudwatchLogsExportConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudwatchLogsExportConfiguration())
      .map(value =>
        zio.aws.neptune.model.CloudwatchLogsExportConfiguration.wrap(value)
      )
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val allowMajorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowMajorVersionUpgrade())
        .map(value => value: Boolean)
    override val dbInstanceParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceParameterGroupName())
        .map(value => value: String)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val serverlessV2ScalingConfiguration: Optional[
      zio.aws.neptune.model.ServerlessV2ScalingConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverlessV2ScalingConfiguration())
      .map(value =>
        zio.aws.neptune.model.ServerlessV2ScalingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest
  ): zio.aws.neptune.model.ModifyDbClusterRequest.ReadOnly = new Wrapper(impl)
}
