package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterResponse(
    dbCluster: Optional[zio.aws.neptune.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse = {
    import ModifyDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ModifyDbClusterResponse.ReadOnly =
    zio.aws.neptune.model.ModifyDbClusterResponse.wrap(buildAwsValue())
}
object ModifyDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyDbClusterResponse =
      zio.aws.neptune.model
        .ModifyDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse
  ) extends zio.aws.neptune.model.ModifyDbClusterResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.neptune.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse
  ): zio.aws.neptune.model.ModifyDbClusterResponse.ReadOnly = new Wrapper(impl)
}
