package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PromoteReadReplicaDbClusterRequest(
    dbClusterIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest = {
    import PromoteReadReplicaDbClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest
      .builder()
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.PromoteReadReplicaDbClusterRequest.ReadOnly =
    zio.aws.neptune.model.PromoteReadReplicaDbClusterRequest
      .wrap(buildAwsValue())
}
object PromoteReadReplicaDbClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.PromoteReadReplicaDbClusterRequest =
      zio.aws.neptune.model
        .PromoteReadReplicaDbClusterRequest(dbClusterIdentifier)
    def dbClusterIdentifier: String
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest
  ) extends zio.aws.neptune.model.PromoteReadReplicaDbClusterRequest.ReadOnly {
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest
  ): zio.aws.neptune.model.PromoteReadReplicaDbClusterRequest.ReadOnly =
    new Wrapper(impl)
}
