package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RemoveFromGlobalClusterResponse(
    globalCluster: Optional[zio.aws.neptune.model.GlobalCluster] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterResponse = {
    import RemoveFromGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.RemoveFromGlobalClusterResponse.ReadOnly =
    zio.aws.neptune.model.RemoveFromGlobalClusterResponse.wrap(buildAwsValue())
}
object RemoveFromGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.RemoveFromGlobalClusterResponse =
      zio.aws.neptune.model.RemoveFromGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterResponse
  ) extends zio.aws.neptune.model.RemoveFromGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalCluster())
        .map(value => zio.aws.neptune.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterResponse
  ): zio.aws.neptune.model.RemoveFromGlobalClusterResponse.ReadOnly =
    new Wrapper(impl)
}
